/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

@NoJSR250Annotations
public class LoggingInInterceptor
extends AbstractLoggingInterceptor {
    private static final Logger LOG = LogUtils.getLogger(LoggingInInterceptor.class);

    public LoggingInInterceptor() {
        super("receive");
    }

    public LoggingInInterceptor(String phase) {
        super(phase);
    }

    public LoggingInInterceptor(String id, String phase) {
        super(id, phase);
    }

    public LoggingInInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LoggingInInterceptor(String id, int lim) {
        this(id, "receive");
        this.limit = lim;
    }

    public LoggingInInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public LoggingInInterceptor(String id, PrintWriter w) {
        this(id, "receive");
        this.writer = w;
    }

    public void handleMessage(Message message) throws Fault {
        Logger logger = this.getMessageLogger(message);
        if (this.writer != null || logger.isLoggable(Level.INFO)) {
            this.logging(logger, message);
        }
    }

    protected void logging(Logger logger, Message message) throws Fault {
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        if (message.containsKey(LoggingMessage.ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get(LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put(LoggingMessage.ID_KEY, id);
        }
        message.put(LoggingMessage.ID_KEY, id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get(Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get(Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get("org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get("Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get(Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get("org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get(Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if (!this.isShowBinaryContent() && this.isBinaryContent(ct)) {
            buffer.getMessage().append("--- Binary Content ---").append('\n');
            this.log(logger, buffer.toString());
            return;
        }
        InputStream is = message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            if (this.threshold > 0L) {
                bos.setThreshold(this.threshold);
            }
            try {
                IOUtils.copy(is, bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > (long)this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
        Reader reader = message.getContent(Reader.class);
        if (reader != null) {
            try {
                BufferedReader r = new BufferedReader(reader, this.limit);
                r.mark(this.limit);
                char[] b = new char[this.limit];
                int i = r.read(b);
                buffer.getPayload().append(b, 0, i);
                r.reset();
                message.setContent(Reader.class, r);
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
        this.log(logger, buffer.toString());
    }

    protected Logger getLogger() {
        return LOG;
    }
}

