/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.monitor.MonitorService;
import com.alibaba.dubbo.monitor.simple.CountUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMonitorService
implements MonitorService {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMonitorService.class);
    private static final String[] types = new String[]{"success", "failure", "elapsed", "concurrent", "max.elapsed", "max.concurrent"};
    private static final String POISON_PROTOCOL = "poison";
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("DubboMonitorTimer", true));
    private final ScheduledFuture<?> chartFuture;
    private final Thread writeThread;
    private final BlockingQueue<URL> queue = new LinkedBlockingQueue<URL>(Integer.parseInt(ConfigUtils.getProperty((String)"dubbo.monitor.queue", (String)"100000")));
    private String statisticsDirectory = "statistics";
    private String chartsDirectory = "charts";
    private volatile boolean running = true;
    private static SimpleMonitorService INSTANCE = null;

    public static SimpleMonitorService getInstance() {
        return INSTANCE;
    }

    public String getStatisticsDirectory() {
        return this.statisticsDirectory;
    }

    public void setStatisticsDirectory(String statistics) {
        if (statistics != null) {
            this.statisticsDirectory = statistics;
        }
    }

    public String getChartsDirectory() {
        return this.chartsDirectory;
    }

    public void setChartsDirectory(String charts) {
        if (charts != null) {
            this.chartsDirectory = charts;
        }
    }

    public SimpleMonitorService() {
        this.writeThread = new Thread(new Runnable(){

            public void run() {
                while (SimpleMonitorService.this.running) {
                    try {
                        SimpleMonitorService.this.write();
                    }
                    catch (Throwable t) {
                        logger.error("Unexpected error occur at write stat log, cause: " + t.getMessage(), t);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
        this.writeThread.setDaemon(true);
        this.writeThread.setName("DubboMonitorAsyncWriteLogThread");
        this.writeThread.start();
        this.chartFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    SimpleMonitorService.this.draw();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error occur at draw stat chart, cause: " + t.getMessage(), t);
                }
            }
        }, 1L, 300L, TimeUnit.SECONDS);
        INSTANCE = this;
    }

    public void close() {
        try {
            this.running = false;
            this.queue.offer(new URL(POISON_PROTOCOL, "127.0.0.1", 0));
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        try {
            this.chartFuture.cancel(true);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws Exception {
        URL statistics = this.queue.take();
        if (POISON_PROTOCOL.equals(statistics.getProtocol())) {
            return;
        }
        String timestamp = statistics.getParameter("timestamp");
        Date now = timestamp == null || timestamp.length() == 0 ? new Date() : (timestamp.length() == "yyyyMMddHHmmss".length() ? new SimpleDateFormat("yyyyMMddHHmmss").parse(timestamp) : new Date(Long.parseLong(timestamp)));
        String day = new SimpleDateFormat("yyyyMMdd").format(now);
        SimpleDateFormat format = new SimpleDateFormat("HHmm");
        for (String key : types) {
            try {
                int i;
                String provider;
                String consumer;
                String type;
                if (statistics.hasParameter("provider")) {
                    type = "consumer";
                    consumer = statistics.getHost();
                    provider = statistics.getParameter("provider");
                    i = provider.indexOf(58);
                    if (i > 0) {
                        provider = provider.substring(0, i);
                    }
                } else {
                    type = "provider";
                    consumer = statistics.getParameter("consumer");
                    i = consumer.indexOf(58);
                    if (i > 0) {
                        consumer = consumer.substring(0, i);
                    }
                    provider = statistics.getHost();
                }
                String filename = this.statisticsDirectory + "/" + day + "/" + statistics.getServiceInterface() + "/" + statistics.getParameter("method") + "/" + consumer + "/" + provider + "/" + type + "." + key;
                File file = new File(filename);
                File dir = file.getParentFile();
                if (dir != null && !dir.exists()) {
                    dir.mkdirs();
                }
                FileWriter writer = new FileWriter(file, true);
                try {
                    writer.write(format.format(now) + " " + statistics.getParameter(key, 0) + "\n");
                    writer.flush();
                }
                finally {
                    writer.close();
                }
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
    }

    private void draw() {
        File[] dateDirs;
        File rootDir = new File(this.statisticsDirectory);
        if (!rootDir.exists()) {
            return;
        }
        for (File dateDir : dateDirs = rootDir.listFiles()) {
            File[] serviceDirs;
            for (File serviceDir : serviceDirs = dateDir.listFiles()) {
                File[] methodDirs;
                for (File methodDir : methodDirs = serviceDir.listFiles()) {
                    File[] consumerDirs;
                    String methodUri = this.chartsDirectory + "/" + dateDir.getName() + "/" + serviceDir.getName() + "/" + methodDir.getName();
                    File successFile = new File(methodUri + "/" + "success" + ".png");
                    long successModified = successFile.lastModified();
                    boolean successChanged = false;
                    HashMap<String, long[]> successData = new HashMap<String, long[]>();
                    double[] successSummary = new double[4];
                    File elapsedFile = new File(methodUri + "/" + "elapsed" + ".png");
                    long elapsedModified = elapsedFile.lastModified();
                    boolean elapsedChanged = false;
                    HashMap<String, long[]> elapsedData = new HashMap<String, long[]>();
                    double[] elapsedSummary = new double[4];
                    long elapsedMax = 0L;
                    for (File consumerDir : consumerDirs = methodDir.listFiles()) {
                        File[] providerDirs;
                        for (File providerDir : providerDirs = consumerDir.listFiles()) {
                            File consumerSuccessFile = new File(providerDir, "consumer.success");
                            File providerSuccessFile = new File(providerDir, "provider.success");
                            this.appendData(new File[]{consumerSuccessFile, providerSuccessFile}, successData, successSummary);
                            if (consumerSuccessFile.lastModified() > successModified || providerSuccessFile.lastModified() > successModified) {
                                successChanged = true;
                            }
                            File consumerElapsedFile = new File(providerDir, "consumer.elapsed");
                            File providerElapsedFile = new File(providerDir, "provider.elapsed");
                            this.appendData(new File[]{consumerElapsedFile, providerElapsedFile}, elapsedData, elapsedSummary);
                            elapsedMax = Math.max(elapsedMax, CountUtils.max(new File(providerDir, "consumer.max.elapsed")));
                            elapsedMax = Math.max(elapsedMax, CountUtils.max(new File(providerDir, "provider.max.elapsed")));
                            if (consumerElapsedFile.lastModified() <= elapsedModified && providerElapsedFile.lastModified() <= elapsedModified) continue;
                            elapsedChanged = true;
                        }
                    }
                    if (elapsedChanged) {
                        this.divData(elapsedData, successData);
                        elapsedSummary[0] = elapsedMax;
                        elapsedSummary[1] = -1.0;
                        elapsedSummary[2] = successSummary[3] == 0.0 ? 0.0 : elapsedSummary[3] / successSummary[3];
                        elapsedSummary[3] = -1.0;
                        SimpleMonitorService.createChart("ms/t", serviceDir.getName(), methodDir.getName(), dateDir.getName(), new String[]{"consumer", "provider"}, elapsedData, elapsedSummary, elapsedFile.getAbsolutePath());
                    }
                    if (!successChanged) continue;
                    this.divData(successData, 60L);
                    successSummary[0] = successSummary[0] / 60.0;
                    successSummary[1] = successSummary[1] / 60.0;
                    successSummary[2] = successSummary[2] / 60.0;
                    SimpleMonitorService.createChart("t/s", serviceDir.getName(), methodDir.getName(), dateDir.getName(), new String[]{"consumer", "provider"}, successData, successSummary, successFile.getAbsolutePath());
                }
            }
        }
    }

    private void divData(Map<String, long[]> successMap, long unit) {
        for (long[] success : successMap.values()) {
            for (int i = 0; i < success.length; ++i) {
                success[i] = success[i] / unit;
            }
        }
    }

    private void divData(Map<String, long[]> elapsedMap, Map<String, long[]> successMap) {
        for (Map.Entry<String, long[]> entry : elapsedMap.entrySet()) {
            long[] elapsed = entry.getValue();
            long[] success = successMap.get(entry.getKey());
            for (int i = 0; i < elapsed.length; ++i) {
                elapsed[i] = success[i] == 0L ? 0L : elapsed[i] / success[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendData(File[] files, Map<String, long[]> data, double[] summary) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) continue;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                try {
                    String line;
                    int sum = 0;
                    int cnt = 0;
                    while ((line = reader.readLine()) != null) {
                        int index = line.indexOf(" ");
                        if (index <= 0) continue;
                        String key = line.substring(0, index).trim();
                        long value = Long.parseLong(line.substring(index + 1).trim());
                        long[] values = data.get(key);
                        if (values == null) {
                            values = new long[files.length];
                            data.put(key, values);
                        }
                        int n = i;
                        values[n] = values[n] + value;
                        summary[0] = Math.max(summary[0], (double)values[i]);
                        summary[1] = summary[1] == 0.0 ? (double)values[i] : Math.min(summary[1], (double)values[i]);
                        sum = (int)((long)sum + value);
                        ++cnt;
                    }
                    if (i != 0) continue;
                    summary[3] = summary[3] + (double)sum;
                    summary[2] = (summary[2] + (double)(sum / cnt)) / 2.0;
                    continue;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createChart(String key, String service, String method, String date, String[] types, Map<String, long[]> data, double[] summary, String path) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        DecimalFormat numberFormat = new DecimalFormat("###,##0.##");
        TimeSeriesCollection xydataset = new TimeSeriesCollection();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            TimeSeries timeseries = new TimeSeries((Comparable)((Object)type));
            for (Map.Entry<String, long[]> entry : data.entrySet()) {
                try {
                    timeseries.add((RegularTimePeriod)new Minute(dateFormat.parse(date + entry.getKey())), (double)entry.getValue()[i]);
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            xydataset.addSeries(timeseries);
        }
        JFreeChart jfreechart = ChartFactory.createTimeSeriesChart((String)("max: " + numberFormat.format(summary[0]) + (summary[1] >= 0.0 ? " min: " + numberFormat.format(summary[1]) : "") + " avg: " + numberFormat.format(summary[2]) + (summary[3] >= 0.0 ? " sum: " + numberFormat.format(summary[3]) : "")), (String)(SimpleMonitorService.toDisplayService(service) + "  " + method + "  " + SimpleMonitorService.toDisplayDate(date)), (String)key, (XYDataset)xydataset, (boolean)true, (boolean)true, (boolean)false);
        jfreechart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setBackgroundPaint((Paint)Color.WHITE);
        xyplot.setDomainGridlinePaint((Paint)Color.GRAY);
        xyplot.setRangeGridlinePaint((Paint)Color.GRAY);
        xyplot.setDomainGridlinesVisible(true);
        xyplot.setRangeGridlinesVisible(true);
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        dateaxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        BufferedImage image = jfreechart.createBufferedImage(600, 300);
        try {
            File methodChartFile;
            File methodChartDir;
            if (logger.isInfoEnabled()) {
                logger.info("write chart: " + path);
            }
            if ((methodChartDir = (methodChartFile = new File(path)).getParentFile()) != null && !methodChartDir.exists()) {
                methodChartDir.mkdirs();
            }
            FileOutputStream output = new FileOutputStream(methodChartFile);
            try {
                ImageIO.write((RenderedImage)image, "png", output);
                output.flush();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static String toDisplayService(String service) {
        int i = service.lastIndexOf(46);
        if (i >= 0) {
            return service.substring(i + 1);
        }
        return service;
    }

    private static String toDisplayDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").format(new SimpleDateFormat("yyyyMMdd").parse(date));
        }
        catch (ParseException e) {
            return date;
        }
    }

    public void count(URL statistics) {
        this.collect(statistics);
    }

    public void collect(URL statistics) {
        this.queue.offer(statistics);
        if (logger.isInfoEnabled()) {
            logger.info("collect statistics: " + statistics);
        }
    }

    public List<URL> lookup(URL query) {
        return null;
    }
}

