/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.math.BigInteger;

public final class RyuDouble {
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_EXPONENT_BITS = 11;
    private static final int DOUBLE_EXPONENT_MASK = 2047;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final long LOG10_2_DENOMINATOR = 10000000L;
    private static final long LOG10_2_NUMERATOR = (long)(1.0E7 * Math.log10(2.0));
    private static final long LOG10_5_DENOMINATOR = 10000000L;
    private static final long LOG10_5_NUMERATOR = (long)(1.0E7 * Math.log10(5.0));
    private static final long LOG2_5_DENOMINATOR = 10000000L;
    private static final long LOG2_5_NUMERATOR = (long)(1.0E7 * (Math.log(5.0) / Math.log(2.0)));
    private static final int POS_TABLE_SIZE = 326;
    private static final int NEG_TABLE_SIZE = 291;
    private static final int POW5_BITCOUNT = 121;
    private static final int POW5_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[326][4];
    private static final int POW5_INV_BITCOUNT = 122;
    private static final int POW5_INV_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[291][4];

    public static String doubleToString(double value) {
        char[] result = new char[24];
        int len = RyuDouble.doubleToString(value, result, 0);
        return new String(result, 0, len);
    }

    public static int doubleToString(double value, char[] result, int off) {
        long output;
        int e10;
        long dm;
        long dp;
        long dv;
        int q;
        long m2;
        int e2;
        int index = off;
        if (Double.isNaN(value)) {
            result[index++] = 78;
            result[index++] = 97;
            result[index++] = 78;
            return index - off;
        }
        if (value == Double.POSITIVE_INFINITY) {
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            result[index++] = 45;
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L) {
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        if (bits == Long.MIN_VALUE) {
            result[index++] = 45;
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m2 = ieeeMantissa | 0x10000000000000L;
        }
        boolean sign = bits < 0L;
        boolean even = (m2 & 1L) == 0L;
        long mv = 4L * m2;
        long mp = 4L * m2 + 2L;
        long mm = 4L * m2 - (long)(m2 != 0x10000000000000L || ieeeExponent <= 1 ? 2 : 1);
        boolean dmIsTrailingZeros = false;
        if ((e2 -= 2) >= 0) {
            q = Math.max(0, (int)((long)e2 * LOG10_2_NUMERATOR / 10000000L) - 1);
            int k = 122 + RyuDouble.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = RyuDouble.mulPow5InvDivPow2(mv, q, i);
            dp = RyuDouble.mulPow5InvDivPow2(mp, q, i);
            dm = RyuDouble.mulPow5InvDivPow2(mm, q, i);
            e10 = q;
            if (q <= 21) {
                if (mm % 5L == 0L) {
                    dmIsTrailingZeros = RyuDouble.multipleOfPowerOf5(mm, q);
                } else if (RyuDouble.multipleOfPowerOf5(mp, q) && !even) {
                    --dp;
                }
            }
        } else {
            q = Math.max(0, (int)((long)(-e2) * LOG10_5_NUMERATOR / 10000000L) - 1);
            int i = -e2 - q;
            int k = RyuDouble.pow5bits(i) - 121;
            int j = q - k;
            dv = RyuDouble.mulPow5divPow2(mv, i, j);
            dp = RyuDouble.mulPow5divPow2(mp, i, j);
            dm = RyuDouble.mulPow5divPow2(mm, i, j);
            e10 = q + e2;
            if (q <= 1) {
                boolean bl = dmIsTrailingZeros = ((mm ^ 0xFFFFFFFFFFFFFFFFL) & 1L) >= (long)q;
                if (!even) {
                    --dp;
                }
            }
        }
        int vplength = RyuDouble.decimalLength(dp);
        int exp = e10 + vplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros && even) {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dp /= 10L;
                lastRemovedDigit = (int)(dv % 10L);
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            if (dmIsTrailingZeros && even) {
                while (!(dm % 10L != 0L || dp < 100L && scientificNotation)) {
                    dp /= 10L;
                    lastRemovedDigit = (int)(dv % 10L);
                    dv /= 10L;
                    dm /= 10L;
                    ++removed;
                }
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                dp /= 10L;
                lastRemovedDigit = (int)(dv % 10L);
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        int olength = vplength - removed;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i = 0; i < olength - 1; ++i) {
                int c = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i] = (char)(48 + c);
            }
            result[index] = (char)(48L + output % 10L);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 100) {
                result[index++] = (char)(48 + exp / 100);
                result[index++] = (char)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
            return index - off;
        }
        if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i = -1; i > exp; --i) {
                result[index++] = 48;
            }
            int current = index;
            for (int i = 0; i < olength; ++i) {
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i;
            for (i = 0; i < olength; ++i) {
                result[index + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i = olength; i < exp + 1; ++i) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            int current = index + 1;
            for (int i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    result[current + olength - i - 1] = 46;
                    --current;
                }
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        return index - off;
    }

    private static int pow5bits(int e) {
        return e == 0 ? 1 : (int)(((long)e * LOG2_5_NUMERATOR + 10000000L - 1L) / 10000000L);
    }

    private static int decimalLength(long v) {
        if (v >= 1000000000000000000L) {
            return 19;
        }
        if (v >= 100000000000000000L) {
            return 18;
        }
        if (v >= 10000000000000000L) {
            return 17;
        }
        if (v >= 1000000000000000L) {
            return 16;
        }
        if (v >= 100000000000000L) {
            return 15;
        }
        if (v >= 10000000000000L) {
            return 14;
        }
        if (v >= 1000000000000L) {
            return 13;
        }
        if (v >= 100000000000L) {
            return 12;
        }
        if (v >= 10000000000L) {
            return 11;
        }
        if (v >= 1000000000L) {
            return 10;
        }
        if (v >= 100000000L) {
            return 9;
        }
        if (v >= 10000000L) {
            return 8;
        }
        if (v >= 1000000L) {
            return 7;
        }
        if (v >= 100000L) {
            return 6;
        }
        if (v >= 10000L) {
            return 5;
        }
        if (v >= 1000L) {
            return 4;
        }
        if (v >= 100L) {
            return 3;
        }
        if (v >= 10L) {
            return 2;
        }
        return 1;
    }

    private static boolean multipleOfPowerOf5(long value, int q) {
        return RyuDouble.pow5Factor(value) >= q;
    }

    private static int pow5Factor(long value) {
        if (value % 5L != 0L) {
            return 0;
        }
        if (value % 25L != 0L) {
            return 1;
        }
        if (value % 125L != 0L) {
            return 2;
        }
        if (value % 625L != 0L) {
            return 3;
        }
        int count = 4;
        value /= 625L;
        while (value > 0L) {
            if (value % 5L != 0L) {
                return count;
            }
            value /= 5L;
            ++count;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    private static long mulPow5InvDivPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_INV_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_INV_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_INV_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_INV_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_INV_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_INV_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_INV_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_INV_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    static {
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger invMask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        for (int i = 0; i < 326; ++i) {
            int j;
            BigInteger pow = BigInteger.valueOf(5L).pow(i);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = RyuDouble.pow5bits(i);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i < POW5_SPLIT.length) {
                for (j = 0; j < 4; ++j) {
                    RyuDouble.POW5_SPLIT[i][j] = pow.shiftRight(pow5len - 121 + (3 - j) * 31).and(mask).intValueExact();
                }
            }
            if (i >= POW5_INV_SPLIT.length) continue;
            j = pow5len - 1 + 122;
            BigInteger inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            for (int k = 0; k < 4; ++k) {
                RyuDouble.POW5_INV_SPLIT[i][k] = k == 0 ? inv.shiftRight((3 - k) * 31).intValueExact() : inv.shiftRight((3 - k) * 31).and(invMask).intValueExact();
            }
        }
    }
}

