/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNacosLogging {
    private static final String NACOS_LOGGING_CONFIG_PROPERTY = "nacos.logging.config";
    private static final String NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY = "nacos.logging.default.config.enabled";
    private static final String NACOS_LOGGING_PATH_PROPERTY = "nacos.logging.path";

    protected String getLocation(String defaultLocation) {
        String location = System.getProperty(NACOS_LOGGING_CONFIG_PROPERTY);
        if (StringUtils.isBlank((CharSequence)location)) {
            if (this.isDefaultConfigEnabled()) {
                return defaultLocation;
            }
            return null;
        }
        return location;
    }

    private boolean isDefaultConfigEnabled() {
        String property = System.getProperty(NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY);
        return property == null || BooleanUtils.toBoolean((String)property);
    }

    public abstract void loadConfiguration();

    static {
        String loggingPath = System.getProperty(NACOS_LOGGING_PATH_PROPERTY);
        if (StringUtils.isBlank((CharSequence)loggingPath)) {
            String userHome = System.getProperty("user.home");
            System.setProperty(NACOS_LOGGING_PATH_PROPERTY, userHome + "/logs/nacos");
        }
    }
}

