/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.backups.FailoverReactor;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.PushReceiver;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class HostReactor {
    private static final long DEFAULT_DELAY = 1000L;
    private static final long UPDATE_HOLD_INTERVAL = 5000L;
    private final Map<String, ScheduledFuture<?>> futureMap = new HashMap();
    private Map<String, ServiceInfo> serviceInfoMap;
    private Map<String, Object> updatingMap;
    private PushReceiver pushReceiver;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;
    private FailoverReactor failoverReactor;
    private String cacheDir;
    private ScheduledExecutorService executor;

    public HostReactor(EventDispatcher eventDispatcher, NamingProxy serverProxy, String cacheDir) {
        this(eventDispatcher, serverProxy, cacheDir, false, UtilAndComs.DEFAULT_POLLING_THREAD_COUNT);
    }

    public HostReactor(EventDispatcher eventDispatcher, NamingProxy serverProxy, String cacheDir, boolean loadCacheAtStart, int pollingThreadCount) {
        this.executor = new ScheduledThreadPoolExecutor(pollingThreadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("com.alibaba.nacos.client.naming.updater");
                return thread;
            }
        });
        this.eventDispatcher = eventDispatcher;
        this.serverProxy = serverProxy;
        this.cacheDir = cacheDir;
        this.serviceInfoMap = loadCacheAtStart ? new ConcurrentHashMap<String, ServiceInfo>(DiskCache.read(this.cacheDir)) : new ConcurrentHashMap<String, ServiceInfo>(16);
        this.updatingMap = new ConcurrentHashMap<String, Object>();
        this.failoverReactor = new FailoverReactor(this, cacheDir);
        this.pushReceiver = new PushReceiver(this);
    }

    public Map<String, ServiceInfo> getServiceInfoMap() {
        return this.serviceInfoMap;
    }

    public synchronized ScheduledFuture<?> addTask(UpdateTask task) {
        return this.executor.schedule(task, 1000L, TimeUnit.MILLISECONDS);
    }

    public ServiceInfo processServiceJSON(String json) {
        ServiceInfo serviceInfo = (ServiceInfo)JSON.parseObject((String)json, ServiceInfo.class);
        ServiceInfo oldService = this.serviceInfoMap.get(serviceInfo.getKey());
        if (serviceInfo.getHosts() == null || !serviceInfo.validate()) {
            return oldService;
        }
        boolean changed = false;
        if (oldService != null) {
            String key;
            Instance host;
            if (oldService.getLastRefTime() > serviceInfo.getLastRefTime()) {
                LogUtils.NAMING_LOGGER.warn("out of date data received, old-t: " + oldService.getLastRefTime() + ", new-t: " + serviceInfo.getLastRefTime());
            }
            this.serviceInfoMap.put(serviceInfo.getKey(), serviceInfo);
            HashMap<String, Instance> oldHostMap = new HashMap<String, Instance>(oldService.getHosts().size());
            for (Object host2 : oldService.getHosts()) {
                oldHostMap.put(host2.toInetAddr(), (Instance)host2);
            }
            HashMap<String, Instance> newHostMap = new HashMap<String, Instance>(serviceInfo.getHosts().size());
            for (Instance host3 : serviceInfo.getHosts()) {
                newHostMap.put(host3.toInetAddr(), host3);
            }
            HashSet<Instance> modHosts = new HashSet<Instance>();
            HashSet<Instance> newHosts = new HashSet<Instance>();
            HashSet<Instance> remvHosts = new HashSet<Instance>();
            ArrayList newServiceHosts = new ArrayList(newHostMap.entrySet());
            for (Map.Entry entry : newServiceHosts) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (oldHostMap.containsKey(key) && !StringUtils.equals((CharSequence)host.toString(), (CharSequence)((Instance)oldHostMap.get(key)).toString())) {
                    modHosts.add(host);
                    continue;
                }
                if (oldHostMap.containsKey(key)) continue;
                newHosts.add(host);
            }
            for (Map.Entry entry : oldHostMap.entrySet()) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (newHostMap.containsKey(key) || newHostMap.containsKey(key)) continue;
                remvHosts.add(host);
            }
            if (newHosts.size() > 0) {
                changed = true;
                LogUtils.NAMING_LOGGER.info("new ips(" + newHosts.size() + ") service: " + serviceInfo.getKey() + " -> " + JSON.toJSONString(newHosts));
            }
            if (remvHosts.size() > 0) {
                changed = true;
                LogUtils.NAMING_LOGGER.info("removed ips(" + remvHosts.size() + ") service: " + serviceInfo.getKey() + " -> " + JSON.toJSONString(remvHosts));
            }
            if (modHosts.size() > 0) {
                changed = true;
                LogUtils.NAMING_LOGGER.info("modified ips(" + modHosts.size() + ") service: " + serviceInfo.getKey() + " -> " + JSON.toJSONString(modHosts));
            }
            serviceInfo.setJsonFromServer(json);
            if (newHosts.size() > 0 || remvHosts.size() > 0 || modHosts.size() > 0) {
                this.eventDispatcher.serviceChanged(serviceInfo);
                DiskCache.write(serviceInfo, this.cacheDir);
            }
        } else {
            changed = true;
            LogUtils.NAMING_LOGGER.info("init new ips(" + serviceInfo.ipCount() + ") service: " + serviceInfo.getKey() + " -> " + JSON.toJSONString((Object)serviceInfo.getHosts()));
            this.serviceInfoMap.put(serviceInfo.getKey(), serviceInfo);
            this.eventDispatcher.serviceChanged(serviceInfo);
            serviceInfo.setJsonFromServer(json);
            DiskCache.write(serviceInfo, this.cacheDir);
        }
        MetricsMonitor.getServiceInfoMapSizeMonitor().set((double)this.serviceInfoMap.size());
        if (changed) {
            LogUtils.NAMING_LOGGER.info("current ips:(" + serviceInfo.ipCount() + ") service: " + serviceInfo.getKey() + " -> " + JSON.toJSONString((Object)serviceInfo.getHosts()));
        }
        return serviceInfo;
    }

    private ServiceInfo getServiceInfo0(String serviceName, String clusters) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        return this.serviceInfoMap.get(key);
    }

    public ServiceInfo getServiceInfoDirectlyFromServer(String serviceName, String clusters) throws NacosException {
        String result = this.serverProxy.queryList(serviceName, clusters, 0, false);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return (ServiceInfo)JSON.parseObject((String)result, ServiceInfo.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String serviceName, String clusters) {
        LogUtils.NAMING_LOGGER.debug("failover-mode: " + this.failoverReactor.isFailoverSwitch());
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        if (this.failoverReactor.isFailoverSwitch()) {
            return this.failoverReactor.getService(key);
        }
        ServiceInfo serviceObj = this.getServiceInfo0(serviceName, clusters);
        if (null == serviceObj) {
            serviceObj = new ServiceInfo(serviceName, clusters);
            this.serviceInfoMap.put(serviceObj.getKey(), serviceObj);
            this.updatingMap.put(serviceName, new Object());
            this.updateServiceNow(serviceName, clusters);
            this.updatingMap.remove(serviceName);
        } else if (this.updatingMap.containsKey(serviceName)) {
            ServiceInfo serviceInfo = serviceObj;
            synchronized (serviceInfo) {
                try {
                    serviceObj.wait(5000L);
                }
                catch (InterruptedException e) {
                    LogUtils.NAMING_LOGGER.error("[getServiceInfo] serviceName:" + serviceName + ", clusters:" + clusters, (Throwable)e);
                }
            }
        }
        this.scheduleUpdateIfAbsent(serviceName, clusters);
        return this.serviceInfoMap.get(serviceObj.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdateIfAbsent(String serviceName, String clusters) {
        if (this.futureMap.get(ServiceInfo.getKey((String)serviceName, (String)clusters)) != null) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = this.futureMap;
        synchronized (map) {
            if (this.futureMap.get(ServiceInfo.getKey((String)serviceName, (String)clusters)) != null) {
                return;
            }
            ScheduledFuture<?> future = this.addTask(new UpdateTask(serviceName, clusters));
            this.futureMap.put(ServiceInfo.getKey((String)serviceName, (String)clusters), future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceNow(String serviceName, String clusters) {
        ServiceInfo oldService = this.getServiceInfo0(serviceName, clusters);
        try {
            String result = this.serverProxy.queryList(serviceName, clusters, this.pushReceiver.getUDPPort(), false);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                this.processServiceJSON(result);
            }
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to update serviceName: " + serviceName, (Throwable)e);
        }
        finally {
            if (oldService != null) {
                ServiceInfo serviceInfo = oldService;
                synchronized (serviceInfo) {
                    oldService.notifyAll();
                }
            }
        }
    }

    public void refreshOnly(String serviceName, String clusters) {
        try {
            this.serverProxy.queryList(serviceName, clusters, this.pushReceiver.getUDPPort(), false);
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to update serviceName: " + serviceName, (Throwable)e);
        }
    }

    public class UpdateTask
    implements Runnable {
        long lastRefTime = Long.MAX_VALUE;
        private String clusters;
        private String serviceName;

        public UpdateTask(String serviceName, String clusters) {
            this.serviceName = serviceName;
            this.clusters = clusters;
        }

        @Override
        public void run() {
            try {
                ServiceInfo serviceObj = (ServiceInfo)HostReactor.this.serviceInfoMap.get(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters));
                if (serviceObj == null) {
                    HostReactor.this.updateServiceNow(this.serviceName, this.clusters);
                    HostReactor.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                    return;
                }
                if (serviceObj.getLastRefTime() <= this.lastRefTime) {
                    HostReactor.this.updateServiceNow(this.serviceName, this.clusters);
                    serviceObj = (ServiceInfo)HostReactor.this.serviceInfoMap.get(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters));
                } else {
                    HostReactor.this.refreshOnly(this.serviceName, this.clusters);
                }
                this.lastRefTime = serviceObj.getLastRefTime();
                if (!HostReactor.this.eventDispatcher.isSubscribed(this.serviceName, this.clusters) && !HostReactor.this.futureMap.containsKey(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters))) {
                    LogUtils.NAMING_LOGGER.info("update task is stopped, service:" + this.serviceName + ", clusters:" + this.clusters);
                    return;
                }
                HostReactor.this.executor.schedule(this, serviceObj.getCacheMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                LogUtils.NAMING_LOGGER.warn("[NA] failed to update serviceName: " + this.serviceName, e);
            }
        }
    }
}

