/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.security;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.naming.net.HttpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProxy {
    private static final Logger SECURITY_LOGGER = LoggerFactory.getLogger(SecurityProxy.class);
    private static final String LOGIN_URL = "/v1/auth/users/login";
    private String contextPath;
    private String username;
    private String password;
    private String accessToken;
    private long tokenTtl;
    private long lastRefreshTime;
    private long tokenRefreshWindow;

    public SecurityProxy(Properties properties) {
        this.username = properties.getProperty("username", "");
        this.password = properties.getProperty("password", "");
        this.contextPath = properties.getProperty("contextPath", "/nacos");
    }

    public boolean login(List<String> servers) {
        try {
            if (System.currentTimeMillis() - this.lastRefreshTime < TimeUnit.SECONDS.toMillis(this.tokenTtl - this.tokenRefreshWindow)) {
                return true;
            }
            for (String server : servers) {
                if (!this.login(server)) continue;
                this.lastRefreshTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean login(String server) {
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("username", this.username);
            String body = "password=" + this.password;
            String url = "http://" + server + this.contextPath + LOGIN_URL;
            if (server.contains("http")) {
                url = server + this.contextPath + LOGIN_URL;
            }
            HttpClient.HttpResult result = HttpClient.request(url, new ArrayList<String>(2), params, body, Charsets.UTF_8.name(), "POST");
            if (result.code != 200) {
                SECURITY_LOGGER.error("login failed: {}", (Object)JSON.toJSONString((Object)result));
                return false;
            }
            JSONObject obj = JSON.parseObject((String)result.content);
            if (obj.containsKey((Object)"accessToken")) {
                this.accessToken = obj.getString("accessToken");
                this.tokenTtl = obj.getIntValue("tokenTtl");
                this.tokenRefreshWindow = this.tokenTtl / 10L;
            }
        }
        return true;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

