/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.identify.STSConfig;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;

public class ServerHttpAgent
implements HttpAgent {
    private static final Logger LOGGER = LogUtils.logger(ServerHttpAgent.class);
    private SecurityProxy securityProxy;
    private String namespaceId;
    private long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    private String accessKey;
    private String secretKey;
    private String encode;
    private int maxRetry = 3;
    private volatile STSCredential sTSCredential;
    final ServerListManager serverListMgr;

    @Override
    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, false);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.code);
            }
            catch (ConnectException ce) {
                LOGGER.error("[NACOS ConnectException httpGet] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ce.getMessage());
            }
            catch (SocketTimeoutException stoe) {
                LOGGER.error("[NACOS SocketTimeoutException httpGet] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)stoe.getMessage());
            }
            catch (IOException ioe) {
                LOGGER.error("[NACOS IOException httpGet] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ioe);
                throw ioe;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-GET] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    @Override
    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)currentServerAddr, (Object)result.code);
            }
            catch (ConnectException ce) {
                LOGGER.error("[NACOS ConnectException httpPost] currentServerAddr: {}, err : {}", (Object)currentServerAddr, (Object)ce.getMessage());
            }
            catch (SocketTimeoutException stoe) {
                LOGGER.error("[NACOS SocketTimeoutException httpPost] currentServerAddr: {}\uff0c err : {}", (Object)currentServerAddr, (Object)stoe.getMessage());
            }
            catch (IOException ioe) {
                LOGGER.error("[NACOS IOException httpPost] currentServerAddr: " + currentServerAddr, (Throwable)ioe);
                throw ioe;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-POST] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server, currentServerAddr : {}", (Object)currentServerAddr);
        throw new ConnectException("no available server, currentServerAddr : " + currentServerAddr);
    }

    @Override
    public HttpSimpleClient.HttpResult httpDelete(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpDelete(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.code);
            }
            catch (ConnectException ce) {
                ce.printStackTrace();
                LOGGER.error("[NACOS ConnectException httpDelete] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ce.getMessage());
            }
            catch (SocketTimeoutException stoe) {
                stoe.printStackTrace();
                LOGGER.error("[NACOS SocketTimeoutException httpDelete] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)stoe.getMessage());
            }
            catch (IOException ioe) {
                LOGGER.error("[NACOS IOException httpDelete] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ioe);
                throw ioe;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-DELETE] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    private String getUrl(String serverAddr, String relativePath) {
        String contextPath = this.serverListMgr.getContentPath().startsWith("/") ? this.serverListMgr.getContentPath() : "/" + this.serverListMgr.getContentPath();
        return serverAddr + contextPath + relativePath;
    }

    public static String getAppname() {
        return ParamUtil.getAppName();
    }

    public ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public ServerHttpAgent(ServerListManager mgr, Properties properties) {
        this.serverListMgr = mgr;
        this.init(properties);
    }

    public ServerHttpAgent(Properties properties) throws NacosException {
        this.serverListMgr = new ServerListManager(properties);
        this.securityProxy = new SecurityProxy(properties);
        this.namespaceId = properties.getProperty("namespace");
        this.init(properties);
        this.securityProxy.login(this.serverListMgr.getServerUrls());
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.config.security.updater");
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ServerHttpAgent.this.securityProxy.login(ServerHttpAgent.this.serverListMgr.getServerUrls());
            }
        }, 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    private void injectSecurityInfo(List<String> params) {
        if (StringUtils.isNotBlank((CharSequence)this.securityProxy.getAccessToken())) {
            params.add("accessToken");
            params.add(this.securityProxy.getAccessToken());
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespaceId) && !params.contains("tenant")) {
            params.add("tenant");
            params.add(this.namespaceId);
        }
    }

    private void init(Properties properties) {
        this.initEncode(properties);
        this.initAkSk(properties);
        this.initMaxRetry(properties);
    }

    private void initEncode(Properties properties) {
        this.encode = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("encode"), new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "UTF-8";
            }
        });
    }

    private void initAkSk(Properties properties) {
        String ak;
        String ramRoleName = properties.getProperty("ramRoleName");
        if (!StringUtils.isBlank((CharSequence)ramRoleName)) {
            STSConfig.getInstance().setRamRoleName(ramRoleName);
        }
        this.accessKey = StringUtils.isBlank((CharSequence)(ak = properties.getProperty("accessKey"))) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank((CharSequence)sk) ? SpasAdapter.getSk() : sk;
    }

    private void initMaxRetry(Properties properties) {
        this.maxRetry = NumberUtils.toInt((String)String.valueOf(properties.get("maxRetry")), (int)3);
    }

    @Override
    public synchronized void start() throws NacosException {
        this.serverListMgr.start();
    }

    private List<String> getSpasHeaders(List<String> paramValues) throws IOException {
        ArrayList<String> newHeaders = new ArrayList<String>();
        if (STSConfig.getInstance().isSTSOn()) {
            STSCredential sTSCredential = this.getSTSCredential();
            this.accessKey = sTSCredential.accessKeyId;
            this.secretKey = sTSCredential.accessKeySecret;
            newHeaders.add("Spas-SecurityToken");
            newHeaders.add(sTSCredential.securityToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.accessKey) && StringUtils.isNotEmpty((CharSequence)this.secretKey)) {
            newHeaders.add("Spas-AccessKey");
            newHeaders.add(this.accessKey);
            List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues, this.secretKey);
            if (signHeaders != null) {
                newHeaders.addAll(signHeaders);
            }
        }
        return newHeaders;
    }

    private STSCredential getSTSCredential() throws IOException {
        STSCredential stsCredentialTmp;
        boolean cacheSecurityCredentials = STSConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.sTSCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.sTSCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = STSConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.sTSCredential;
            }
        }
        String stsResponse = ServerHttpAgent.getSTSResponse();
        this.sTSCredential = stsCredentialTmp = (STSCredential)JacksonUtils.toObj((String)stsResponse, (TypeReference)new TypeReference<STSCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.sTSCredential.getCode(), this.sTSCredential.getAccessKeyId(), this.sTSCredential.getLastUpdated(), this.sTSCredential.getExpiration()});
        return this.sTSCredential;
    }

    private static String getSTSResponse() throws IOException {
        String response;
        int respCode;
        String securityCredentials = STSConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = STSConfig.getInstance().getSecurityCredentialsUrl();
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(securityCredentialsUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 100 ? ParamUtil.getConnectTimeout() : 100);
            conn.setReadTimeout(1000);
            conn.connect();
            respCode = conn.getResponseCode();
            response = 200 == respCode ? IoUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8") : IoUtils.toString((InputStream)conn.getErrorStream(), (String)"UTF-8");
        }
        catch (IOException e) {
            try {
                LOGGER.error("can not get security credentials", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        if (200 == respCode) {
            return response;
        }
        LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, respCode, response});
        throw new IOException("can not get security credentials, responseCode: " + respCode + ", response: " + response);
    }

    @Override
    public String getName() {
        return this.serverListMgr.getName();
    }

    @Override
    public String getNamespace() {
        return this.serverListMgr.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.serverListMgr.getTenant();
    }

    @Override
    public String getEncode() {
        return this.encode;
    }

    private static class STSCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private STSCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }
}

