/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValidatorUtils {
    private static final Pattern CONTEXT_PATH_MATCH = Pattern.compile("(\\/)\\1+");
    private static final Pattern IP_MATCH = Pattern.compile("([^\\/:]+)(:\\d+)");

    public static void checkInitParam(Properties properties) {
        ValidatorUtils.checkServerAddr(properties.getProperty("serverAddr"));
        ValidatorUtils.checkContextPath(properties.getProperty("contextPath"));
    }

    public static void checkServerAddr(String serverAddr) {
        if (StringUtils.isEmpty((String)serverAddr)) {
            throw new IllegalArgumentException("Please set the serverAddr");
        }
        String[] addrs = serverAddr.contains(",") ? serverAddr.split(",") : new String[]{serverAddr};
        for (String addr : addrs) {
            Matcher matcher = IP_MATCH.matcher(addr.trim());
            if (matcher.find()) continue;
            throw new IllegalArgumentException("Incorrect serverAddr address : " + addr + ", example should like ip:port or domain:port");
        }
    }

    public static void checkContextPath(String contextPath) {
        if (contextPath == null) {
            return;
        }
        Matcher matcher = CONTEXT_PATH_MATCH.matcher(contextPath);
        if (matcher.find()) {
            throw new IllegalArgumentException("Illegal url path expression");
        }
    }
}

