/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.AbstractLogPositionManager;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.parse.index.ZooKeeperLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedLogPositionManager
extends AbstractLogPositionManager {
    private final Logger logger = LoggerFactory.getLogger(MixedLogPositionManager.class);
    private final MemoryLogPositionManager memoryLogPositionManager;
    private final ZooKeeperLogPositionManager zooKeeperLogPositionManager;
    private final ExecutorService executor;

    public MixedLogPositionManager(ZkClientx zkClient) {
        if (zkClient == null) {
            throw new NullPointerException("null zkClient");
        }
        this.memoryLogPositionManager = new MemoryLogPositionManager();
        this.zooKeeperLogPositionManager = new ZooKeeperLogPositionManager(zkClient);
        this.executor = Executors.newFixedThreadPool(1);
    }

    public void start() {
        super.start();
        if (!this.memoryLogPositionManager.isStart()) {
            this.memoryLogPositionManager.start();
        }
        if (!this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.start();
        }
    }

    public void stop() {
        super.stop();
        this.executor.shutdown();
        this.zooKeeperLogPositionManager.stop();
        this.memoryLogPositionManager.stop();
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = this.memoryLogPositionManager.getLatestIndexBy(destination);
        if (logPosition != null) {
            return logPosition;
        }
        logPosition = this.zooKeeperLogPositionManager.getLatestIndexBy(destination);
        if (logPosition != null) {
            this.memoryLogPositionManager.persistLogPosition(destination, logPosition);
        }
        return logPosition;
    }

    @Override
    public void persistLogPosition(final String destination, final LogPosition logPosition) throws CanalParseException {
        this.memoryLogPositionManager.persistLogPosition(destination, logPosition);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MixedLogPositionManager.this.zooKeeperLogPositionManager.persistLogPosition(destination, logPosition);
                }
                catch (Exception e) {
                    MixedLogPositionManager.this.logger.error("ERROR # persist to zookeeper has an error", (Throwable)e);
                }
            }
        });
    }
}

