/**
 * Copyright (C) 2010-2013 Alibaba Group Holding Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.rocketmq.common.message;

import java.net.SocketAddress;


/**
 * @author shijia.wxr<vintage.wang@gmail.com>
 */
public class MessageId {
    private SocketAddress address;
    private long offset;


    public MessageId(SocketAddress address, long offset) {
        this.address = address;
        this.offset = offset;
    }


    public SocketAddress getAddress() {
        return address;
    }


    public void setAddress(SocketAddress address) {
        this.address = address;
    }


    public long getOffset() {
        return offset;
    }


    public void setOffset(long offset) {
        this.offset = offset;
    }
}
