package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 资金池账户解绑
 *
 * @author auto create
 * @since 1.0, 2020-05-29 16:29:04
 */
public class AlipayAccountCashpoolAccountUnbindModel extends AlipayObject {

	private static final long serialVersionUID = 1231569751494973862L;

	/**
	 * 资金池唯一标识
	 */
	@ApiField("cash_pool_id")
	private String cashPoolId;

	/**
	 * 当前账户，仅须填写account_no和account_type
	 */
	@ApiField("inst_account")
	private InstAccountDTO instAccount;

	/**
	 * 操作员
	 */
	@ApiField("operator")
	private String operator;

	/**
	 * 父账户，仅须填写account_no和account_type
	 */
	@ApiField("parent_inst_account")
	private InstAccountDTO parentInstAccount;

	public String getCashPoolId() {
		return this.cashPoolId;
	}
	public void setCashPoolId(String cashPoolId) {
		this.cashPoolId = cashPoolId;
	}

	public InstAccountDTO getInstAccount() {
		return this.instAccount;
	}
	public void setInstAccount(InstAccountDTO instAccount) {
		this.instAccount = instAccount;
	}

	public String getOperator() {
		return this.operator;
	}
	public void setOperator(String operator) {
		this.operator = operator;
	}

	public InstAccountDTO getParentInstAccount() {
		return this.parentInstAccount;
	}
	public void setParentInstAccount(InstAccountDTO parentInstAccount) {
		this.parentInstAccount = parentInstAccount;
	}

}
