package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 应付发票综合查询
 *
 * @author auto create
 * @since 1.0, 2020-10-20 15:13:08
 */
public class AlipayBossFncApinvoiceBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 3392613475563337554L;

	/**
	 * 账单号
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 业务类型
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 购方机构id
	 */
	@ApiField("buyer_inst_id")
	private String buyerInstId;

	/**
	 * 购方发票抬头
	 */
	@ApiField("buyer_invoice_title")
	private String buyerInvoiceTitle;

	/**
	 * 币种信息CNY or 156等，参考com.alipay.fc.common.lang.money.CurrencyEnum
	 */
	@ApiField("ccy")
	private String ccy;

	/**
	 * 发票认证开始日期 格式yyyyMMdd  小于等于invoiceAuthDateEnd
	 */
	@ApiField("invoice_auth_date_begin")
	private String invoiceAuthDateBegin;

	/**
	 * 发票认证结束日期 格式yyyyMMdd
	 */
	@ApiField("invoice_auth_date_end")
	private String invoiceAuthDateEnd;

	/**
	 * 发票代码
	 */
	@ApiField("invoice_code")
	private String invoiceCode;

	/**
	 * 发票开始日期 格式yyyyMMdd  小于等于invoiceDateEnd
	 */
	@ApiField("invoice_date_begin")
	private String invoiceDateBegin;

	/**
	 * 发票结束日期 格式yyyyMMdd
	 */
	@ApiField("invoice_date_end")
	private String invoiceDateEnd;

	/**
	 * 发票录入开始日期 格式yyyyMMdd  小于等于invoiceInputDateEnd
	 */
	@ApiField("invoice_input_date_begin")
	private String invoiceInputDateBegin;

	/**
	 * 发票录入结束日期 格式yyyyMMdd
	 */
	@ApiField("invoice_input_date_end")
	private String invoiceInputDateEnd;

	/**
	 * 发票号码
	 */
	@ApiField("invoice_no")
	private String invoiceNo;

	/**
	 * 收票开始日期 格式yyyyMMdd  小于等于invoiceReceiveDateEnd
	 */
	@ApiField("invoice_receive_date_begin")
	private String invoiceReceiveDateBegin;

	/**
	 * 收票结束日期 格式yyyyMMdd
	 */
	@ApiField("invoice_receive_date_end")
	private String invoiceReceiveDateEnd;

	/**
	 * 发票状态列表{"01":"发票已提交","02":"审核中(已收票)","03":"已审核","04":"已驳回","05":"已认证","06":"已撤回"}
	 */
	@ApiListField("invoice_status")
	@ApiField("string")
	private List<String> invoiceStatus;

	/**
	 * 发票类型列表{"01":"增值税专用发票","02":"增值税普通发票","03":"营业税发票","04":"国际形式发票","41":"国际形式INVOICE发票","42":"国际形式TaxInvoice发票","43":"国际形式Billing发票","44":"国际形式CreditMemo发票","05":"其它发票","06":"抵扣发票","07":"虚拟发票"}
	 */
	@ApiListField("invoice_types")
	@ApiField("string")
	private List<String> invoiceTypes;

	/**
	 * 邮寄状态列表 {"01":"ISV发票待邮寄","02":"ISV发票邮寄中","03":"ISV发票已收","04":"驳回待邮寄","05":"驳回邮寄中","06":"驳回已收"}
	 */
	@ApiListField("mail_status")
	@ApiField("string")
	private List<String> mailStatus;

	/**
	 * 起始页；默认1
	 */
	@ApiField("page_no")
	private Long pageNo;

	/**
	 * 每页显示数；默认20，最大建议不超过1000
	 */
	@ApiField("page_size")
	private Long pageSize;

	/**
	 * 销方公司名称
	 */
	@ApiField("seller_company_name")
	private String sellerCompanyName;

	/**
	 * 销方PID
	 */
	@ApiField("seller_ip_role_id")
	private String sellerIpRoleId;

	/**
	 * 销方PID列表 sellerIpRoleIds.size() <= 200
	 */
	@ApiListField("seller_ip_role_ids")
	@ApiField("string")
	private List<String> sellerIpRoleIds;

	/**
	 * 销方mid
	 */
	@ApiField("seller_mid")
	private String sellerMid;

	/**
	 * 销方Mid列表
sellerMids.size() <= 200
	 */
	@ApiListField("seller_mids")
	@ApiField("string")
	private List<String> sellerMids;

	/**
	 * 快递单号
	 */
	@ApiField("tracking_no")
	private String trackingNo;

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBuyerInstId() {
		return this.buyerInstId;
	}
	public void setBuyerInstId(String buyerInstId) {
		this.buyerInstId = buyerInstId;
	}

	public String getBuyerInvoiceTitle() {
		return this.buyerInvoiceTitle;
	}
	public void setBuyerInvoiceTitle(String buyerInvoiceTitle) {
		this.buyerInvoiceTitle = buyerInvoiceTitle;
	}

	public String getCcy() {
		return this.ccy;
	}
	public void setCcy(String ccy) {
		this.ccy = ccy;
	}

	public String getInvoiceAuthDateBegin() {
		return this.invoiceAuthDateBegin;
	}
	public void setInvoiceAuthDateBegin(String invoiceAuthDateBegin) {
		this.invoiceAuthDateBegin = invoiceAuthDateBegin;
	}

	public String getInvoiceAuthDateEnd() {
		return this.invoiceAuthDateEnd;
	}
	public void setInvoiceAuthDateEnd(String invoiceAuthDateEnd) {
		this.invoiceAuthDateEnd = invoiceAuthDateEnd;
	}

	public String getInvoiceCode() {
		return this.invoiceCode;
	}
	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceDateBegin() {
		return this.invoiceDateBegin;
	}
	public void setInvoiceDateBegin(String invoiceDateBegin) {
		this.invoiceDateBegin = invoiceDateBegin;
	}

	public String getInvoiceDateEnd() {
		return this.invoiceDateEnd;
	}
	public void setInvoiceDateEnd(String invoiceDateEnd) {
		this.invoiceDateEnd = invoiceDateEnd;
	}

	public String getInvoiceInputDateBegin() {
		return this.invoiceInputDateBegin;
	}
	public void setInvoiceInputDateBegin(String invoiceInputDateBegin) {
		this.invoiceInputDateBegin = invoiceInputDateBegin;
	}

	public String getInvoiceInputDateEnd() {
		return this.invoiceInputDateEnd;
	}
	public void setInvoiceInputDateEnd(String invoiceInputDateEnd) {
		this.invoiceInputDateEnd = invoiceInputDateEnd;
	}

	public String getInvoiceNo() {
		return this.invoiceNo;
	}
	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceReceiveDateBegin() {
		return this.invoiceReceiveDateBegin;
	}
	public void setInvoiceReceiveDateBegin(String invoiceReceiveDateBegin) {
		this.invoiceReceiveDateBegin = invoiceReceiveDateBegin;
	}

	public String getInvoiceReceiveDateEnd() {
		return this.invoiceReceiveDateEnd;
	}
	public void setInvoiceReceiveDateEnd(String invoiceReceiveDateEnd) {
		this.invoiceReceiveDateEnd = invoiceReceiveDateEnd;
	}

	public List<String> getInvoiceStatus() {
		return this.invoiceStatus;
	}
	public void setInvoiceStatus(List<String> invoiceStatus) {
		this.invoiceStatus = invoiceStatus;
	}

	public List<String> getInvoiceTypes() {
		return this.invoiceTypes;
	}
	public void setInvoiceTypes(List<String> invoiceTypes) {
		this.invoiceTypes = invoiceTypes;
	}

	public List<String> getMailStatus() {
		return this.mailStatus;
	}
	public void setMailStatus(List<String> mailStatus) {
		this.mailStatus = mailStatus;
	}

	public Long getPageNo() {
		return this.pageNo;
	}
	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public String getSellerCompanyName() {
		return this.sellerCompanyName;
	}
	public void setSellerCompanyName(String sellerCompanyName) {
		this.sellerCompanyName = sellerCompanyName;
	}

	public String getSellerIpRoleId() {
		return this.sellerIpRoleId;
	}
	public void setSellerIpRoleId(String sellerIpRoleId) {
		this.sellerIpRoleId = sellerIpRoleId;
	}

	public List<String> getSellerIpRoleIds() {
		return this.sellerIpRoleIds;
	}
	public void setSellerIpRoleIds(List<String> sellerIpRoleIds) {
		this.sellerIpRoleIds = sellerIpRoleIds;
	}

	public String getSellerMid() {
		return this.sellerMid;
	}
	public void setSellerMid(String sellerMid) {
		this.sellerMid = sellerMid;
	}

	public List<String> getSellerMids() {
		return this.sellerMids;
	}
	public void setSellerMids(List<String> sellerMids) {
		this.sellerMids = sellerMids;
	}

	public String getTrackingNo() {
		return this.trackingNo;
	}
	public void setTrackingNo(String trackingNo) {
		this.trackingNo = trackingNo;
	}

}
