package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * K12一脸通行集采照片开通申请
 *
 * @author auto create
 * @since 1.0, 2021-02-23 17:19:56
 */
public class AlipayCommerceEducateSceneInviteAddModel extends AlipayObject {

	private static final long serialVersionUID = 4344167761317575225L;

	/**
	 * 证件号。
	 */
	@ApiField("cert_no")
	private String certNo;

	/**
	 * 1:身份证 A:护照。
	 */
	@ApiField("cert_type")
	private String certType;

	/**
	 * 学生上半身照片的访问地址，需外网可访问。（注：1.图片的格式必须是jpg的；2.图片大小不超过200KB；3.协议暂只支持https；）
	 */
	@ApiField("image_url")
	private String imageUrl;

	/**
	 * 外部照片Id，关联当前提交的学生信息。（注：如果同一个学生尝试重新提交，请务必生成新的id）
	 */
	@ApiField("out_photo_id")
	private String outPhotoId;

	/**
	 * 学生家长支付宝账号绑定的手机号。
	 */
	@ApiField("parent_phone_number")
	private String parentPhoneNumber;

	/**
	 * 学校外标（即学校的统一信用编码）。
	 */
	@ApiField("school_std_code")
	private String schoolStdCode;

	/**
	 * 学生姓名。
	 */
	@ApiField("student_name")
	private String studentName;

	public String getCertNo() {
		return this.certNo;
	}
	public void setCertNo(String certNo) {
		this.certNo = certNo;
	}

	public String getCertType() {
		return this.certType;
	}
	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getImageUrl() {
		return this.imageUrl;
	}
	public void setImageUrl(String imageUrl) {
		this.imageUrl = imageUrl;
	}

	public String getOutPhotoId() {
		return this.outPhotoId;
	}
	public void setOutPhotoId(String outPhotoId) {
		this.outPhotoId = outPhotoId;
	}

	public String getParentPhoneNumber() {
		return this.parentPhoneNumber;
	}
	public void setParentPhoneNumber(String parentPhoneNumber) {
		this.parentPhoneNumber = parentPhoneNumber;
	}

	public String getSchoolStdCode() {
		return this.schoolStdCode;
	}
	public void setSchoolStdCode(String schoolStdCode) {
		this.schoolStdCode = schoolStdCode;
	}

	public String getStudentName() {
		return this.studentName;
	}
	public void setStudentName(String studentName) {
		this.studentName = studentName;
	}

}
