package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 团油劵订单查询
 *
 * @author auto create
 * @since 1.0, 2020-11-23 11:35:01
 */
public class AlipayCommerceGasInfoOrdercouponQueryModel extends AlipayObject {

	private static final long serialVersionUID = 7314976213385933542L;

	/**
	 * 订单创建结束时间
	 */
	@ApiField("create_end_time")
	private Date createEndTime;

	/**
	 * 订单创建开始时间
	 */
	@ApiField("create_start_time")
	private Date createStartTime;

	/**
	 * 当前页码,不填写默认第一页
	 */
	@ApiField("page_num")
	private String pageNum;

	/**
	 * 每页显示数,不填写默认10条
	 */
	@ApiField("page_size")
	private Long pageSize;

	/**
	 * 商户ID
	 */
	@ApiField("partner_id")
	private String partnerId;

	/**
	 * 店铺ID
	 */
	@ApiField("shop_id")
	private String shopId;

	/**
	 * 多个逗号分开","INIT_CLOSE,SUCCESS
订单状态 INIT:初始状态,INIT_CLOSE:初始状态关闭,UNPAID:待支付,UNPAID_CLOSE:待支付状态关闭,PAID:已支付,SUCCESS:成功,CLOSED:已关闭,FINISH:完结
	 */
	@ApiField("status")
	private String status;

	/**
	 * 用户ID
	 */
	@ApiField("user_id")
	private String userId;

	public Date getCreateEndTime() {
		return this.createEndTime;
	}
	public void setCreateEndTime(Date createEndTime) {
		this.createEndTime = createEndTime;
	}

	public Date getCreateStartTime() {
		return this.createStartTime;
	}
	public void setCreateStartTime(Date createStartTime) {
		this.createStartTime = createStartTime;
	}

	public String getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(String pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public String getPartnerId() {
		return this.partnerId;
	}
	public void setPartnerId(String partnerId) {
		this.partnerId = partnerId;
	}

	public String getShopId() {
		return this.shopId;
	}
	public void setShopId(String shopId) {
		this.shopId = shopId;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
