package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 商米屏幕订单取消
 *
 * @author auto create
 * @since 1.0, 2021-05-24 11:38:38
 */
public class AlipayCommerceIotMediaOrderCancelModel extends AlipayObject {

	private static final long serialVersionUID = 2246558921857486684L;

	/**
	 * operate_time 操作时间，由调用方传入
	 */
	@ApiField("operate_time")
	private Date operateTime;

	/**
	 * order_id 唯一 商米工作人员取消订单id
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * sub_order_id_list 商米工作人员上门服务完，确认订单用，这里传的子订单id列表，详细到每个屏幕
	 */
	@ApiListField("sub_order_id_list")
	@ApiField("string")
	private List<String> subOrderIdList;

	public Date getOperateTime() {
		return this.operateTime;
	}
	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public List<String> getSubOrderIdList() {
		return this.subOrderIdList;
	}
	public void setSubOrderIdList(List<String> subOrderIdList) {
		this.subOrderIdList = subOrderIdList;
	}

}
