package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 商米屏幕订单确认
 *
 * @author auto create
 * @since 1.0, 2021-05-25 11:11:53
 */
public class AlipayCommerceIotMediaOrderConfirmModel extends AlipayObject {

	private static final long serialVersionUID = 2746725885954992295L;

	/**
	 * fee 屏幕维修费用，维修时才有
	 */
	@ApiField("fee")
	private String fee;

	/**
	 * operate_time 安装或者维修时间
	 */
	@ApiField("operate_time")
	private Date operateTime;

	/**
	 * order_id 唯一 商米工作人员上门服务完，确认订单传的订单id，从订单里获取订单id
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * sub_order_list 订单确认中子订单信息，由操作人员拉取填写
	 */
	@ApiListField("sub_order_list")
	@ApiField("sub_order")
	private List<SubOrder> subOrderList;

	public String getFee() {
		return this.fee;
	}
	public void setFee(String fee) {
		this.fee = fee;
	}

	public Date getOperateTime() {
		return this.operateTime;
	}
	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public List<SubOrder> getSubOrderList() {
		return this.subOrderList;
	}
	public void setSubOrderList(List<SubOrder> subOrderList) {
		this.subOrderList = subOrderList;
	}

}
