package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * ETC扣款协议查询
 *
 * @author auto create
 * @since 1.0, 2021-12-09 21:22:07
 */
public class AlipayCommerceTransportEtcAgreementQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3699595881281369137L;

	/**
	 * 支付宝侧订单号
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 发行方侧订单号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * "BLUE": "蓝色"; 
"YELLOW": "黄色"; 
"BLACK": "黑色"; 
"WHITE": "白色"; 
"GREEN": "绿色";
"LIMEGREEN": "黄绿色"
	 */
	@ApiField("plate_color")
	private String plateColor;

	/**
	 * 办理车牌
	 */
	@ApiField("plate_no")
	private String plateNo;

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getPlateColor() {
		return this.plateColor;
	}
	public void setPlateColor(String plateColor) {
		this.plateColor = plateColor;
	}

	public String getPlateNo() {
		return this.plateNo;
	}
	public void setPlateNo(String plateNo) {
		this.plateNo = plateNo;
	}

}
