package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * ETC办理申请单信息同步
 *
 * @author auto create
 * @since 1.0, 2021-12-14 12:02:27
 */
public class AlipayCommerceTransportEtcApplyorderSyncModel extends AlipayObject {

	private static final long serialVersionUID = 3648664711373838413L;

	/**
	 * 是否代人办理订单: 代人办理 true; 本人办理 false;
	 */
	@ApiField("agent_flag")
	private Boolean agentFlag;

	/**
	 * 支付宝授权id，在用户前端授权页面同意授权之后生成，同意授权的订单必传
	 */
	@ApiField("agree_id")
	private String agreeId;

	/**
	 * 申请类型, 
货车：TRUCK；
客车：CAR
	 */
	@ApiField("apply_type")
	private String applyType;

	/**
	 * 车辆核定载质量
	 */
	@ApiField("approved_load")
	private String approvedLoad;

	/**
	 * 车轴数
	 */
	@ApiField("axle_count")
	private String axleCount;

	/**
	 * 业务发生时间；对应order_status 几个状态的变更时间； 当order_status = DELIVERYED 时 biz_time 为物流发货时间；order_status = ACTIVATED时 biz_time为设备激活时间，以此类推
	 */
	@ApiField("biz_time")
	private String bizTime;

	/**
	 * 行驶证上的品牌型号
	 */
	@ApiField("brand_model")
	private String brandModel;

	/**
	 * 用户ETC卡号，激活状态时必传
	 */
	@ApiField("card_no")
	private String cardNo;

	/**
	 * 审核不通过原因， 审核不通过时必传
	 */
	@ApiField("censor_info")
	private String censorInfo;

	/**
	 * 已发货状态必传，物流公司编码，需要与菜鸟映射
	 */
	@ApiField("delivery_code")
	private String deliveryCode;

	/**
	 * 已发货状态必传，物流公司名称
	 */
	@ApiField("delivery_name")
	private String deliveryName;

	/**
	 * 已发货状态必传，物流单号
	 */
	@ApiField("delivery_no")
	private String deliveryNo;

	/**
	 * 用户ETC OBU号， 激活状态时必传
	 */
	@ApiField("device_no")
	private String deviceNo;

	/**
	 * 车辆发动机号，用户同意信息回流时必传
	 */
	@ApiField("engine_no")
	private String engineNo;

	/**
	 * 车辆发证日期
	 */
	@ApiField("grant_date")
	private String grantDate;

	/**
	 * 车辆总质量
	 */
	@ApiField("gross_mass")
	private String grossMass;

	/**
	 * 支付宝侧订单号
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 订单状态； 
1、DELIVERYED：已发货；
2、RECEIVED：已收货；
3、INFO_SUBMIT：信息已提交
4、CENSOR_PASS：审核通过；
5、CENSOR_BLOCK：审核驳回
6、ACTIVATED：已激活； 
7、UNMOUNTING：注销中；
8、UNMOUNTED：已注销； 
9、CANCELING：取消中；
10、CANCEL：取消；
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 外部业务号，对应用户该笔ETC申请单号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 车辆外廓尺寸
	 */
	@ApiField("outline_size")
	private String outlineSize;

	/**
	 * "BLUE": "蓝色"; 
"YELLOW": "黄色"; 
"BLACK": "黑色"; 
"WHITE": "白色"; 
"GREEN": "绿色";
"LIMEGREEN": "黄绿色"
	 */
	@ApiField("plate_color")
	private String plateColor;

	/**
	 * 办理车牌
	 */
	@ApiField("plate_no")
	private String plateNo;

	/**
	 * 车辆注册日期，用户同意信息回流时必传
	 */
	@ApiField("register_date")
	private String registerDate;

	/**
	 * 车辆准牵引总质量
	 */
	@ApiField("traction_mass")
	private String tractionMass;

	/**
	 * 车辆整备质量
	 */
	@ApiField("unladen_mass")
	private String unladenMass;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	/**
	 * 核定载人数，不带单位
	 */
	@ApiField("vehicle_ac")
	private String vehicleAc;

	/**
	 * 车主身份证号，用户同意信息回流时必传
	 */
	@ApiField("vehicle_owner_cert_no")
	private String vehicleOwnerCertNo;

	/**
	 * 车主联系方式，用户同意信息回流时必传
	 */
	@ApiField("vehicle_owner_contact")
	private String vehicleOwnerContact;

	/**
	 * 车主姓名，用户同意信息回流时必传
	 */
	@ApiField("vehicle_owner_name")
	private String vehicleOwnerName;

	/**
	 * 车主类型；
PRESONAL：个人用户
ENTERPRISE：企业用户
	 */
	@ApiField("vehicle_owner_type")
	private String vehicleOwnerType;

	/**
	 * 车辆类型，行驶证上的值，小型轿车；用户同意信息回流时必传
	 */
	@ApiField("vehicle_type")
	private String vehicleType;

	/**
	 * 车辆使用性质，营运/非营运，用户同意信息回流时必传
	 */
	@ApiField("vehicle_use_type")
	private String vehicleUseType;

	/**
	 * 车辆识别号，请勿乱传，会校验格式；用户同意信息回流时必传
	 */
	@ApiField("vin")
	private String vin;

	public Boolean getAgentFlag() {
		return this.agentFlag;
	}
	public void setAgentFlag(Boolean agentFlag) {
		this.agentFlag = agentFlag;
	}

	public String getAgreeId() {
		return this.agreeId;
	}
	public void setAgreeId(String agreeId) {
		this.agreeId = agreeId;
	}

	public String getApplyType() {
		return this.applyType;
	}
	public void setApplyType(String applyType) {
		this.applyType = applyType;
	}

	public String getApprovedLoad() {
		return this.approvedLoad;
	}
	public void setApprovedLoad(String approvedLoad) {
		this.approvedLoad = approvedLoad;
	}

	public String getAxleCount() {
		return this.axleCount;
	}
	public void setAxleCount(String axleCount) {
		this.axleCount = axleCount;
	}

	public String getBizTime() {
		return this.bizTime;
	}
	public void setBizTime(String bizTime) {
		this.bizTime = bizTime;
	}

	public String getBrandModel() {
		return this.brandModel;
	}
	public void setBrandModel(String brandModel) {
		this.brandModel = brandModel;
	}

	public String getCardNo() {
		return this.cardNo;
	}
	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getCensorInfo() {
		return this.censorInfo;
	}
	public void setCensorInfo(String censorInfo) {
		this.censorInfo = censorInfo;
	}

	public String getDeliveryCode() {
		return this.deliveryCode;
	}
	public void setDeliveryCode(String deliveryCode) {
		this.deliveryCode = deliveryCode;
	}

	public String getDeliveryName() {
		return this.deliveryName;
	}
	public void setDeliveryName(String deliveryName) {
		this.deliveryName = deliveryName;
	}

	public String getDeliveryNo() {
		return this.deliveryNo;
	}
	public void setDeliveryNo(String deliveryNo) {
		this.deliveryNo = deliveryNo;
	}

	public String getDeviceNo() {
		return this.deviceNo;
	}
	public void setDeviceNo(String deviceNo) {
		this.deviceNo = deviceNo;
	}

	public String getEngineNo() {
		return this.engineNo;
	}
	public void setEngineNo(String engineNo) {
		this.engineNo = engineNo;
	}

	public String getGrantDate() {
		return this.grantDate;
	}
	public void setGrantDate(String grantDate) {
		this.grantDate = grantDate;
	}

	public String getGrossMass() {
		return this.grossMass;
	}
	public void setGrossMass(String grossMass) {
		this.grossMass = grossMass;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getOutlineSize() {
		return this.outlineSize;
	}
	public void setOutlineSize(String outlineSize) {
		this.outlineSize = outlineSize;
	}

	public String getPlateColor() {
		return this.plateColor;
	}
	public void setPlateColor(String plateColor) {
		this.plateColor = plateColor;
	}

	public String getPlateNo() {
		return this.plateNo;
	}
	public void setPlateNo(String plateNo) {
		this.plateNo = plateNo;
	}

	public String getRegisterDate() {
		return this.registerDate;
	}
	public void setRegisterDate(String registerDate) {
		this.registerDate = registerDate;
	}

	public String getTractionMass() {
		return this.tractionMass;
	}
	public void setTractionMass(String tractionMass) {
		this.tractionMass = tractionMass;
	}

	public String getUnladenMass() {
		return this.unladenMass;
	}
	public void setUnladenMass(String unladenMass) {
		this.unladenMass = unladenMass;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getVehicleAc() {
		return this.vehicleAc;
	}
	public void setVehicleAc(String vehicleAc) {
		this.vehicleAc = vehicleAc;
	}

	public String getVehicleOwnerCertNo() {
		return this.vehicleOwnerCertNo;
	}
	public void setVehicleOwnerCertNo(String vehicleOwnerCertNo) {
		this.vehicleOwnerCertNo = vehicleOwnerCertNo;
	}

	public String getVehicleOwnerContact() {
		return this.vehicleOwnerContact;
	}
	public void setVehicleOwnerContact(String vehicleOwnerContact) {
		this.vehicleOwnerContact = vehicleOwnerContact;
	}

	public String getVehicleOwnerName() {
		return this.vehicleOwnerName;
	}
	public void setVehicleOwnerName(String vehicleOwnerName) {
		this.vehicleOwnerName = vehicleOwnerName;
	}

	public String getVehicleOwnerType() {
		return this.vehicleOwnerType;
	}
	public void setVehicleOwnerType(String vehicleOwnerType) {
		this.vehicleOwnerType = vehicleOwnerType;
	}

	public String getVehicleType() {
		return this.vehicleType;
	}
	public void setVehicleType(String vehicleType) {
		this.vehicleType = vehicleType;
	}

	public String getVehicleUseType() {
		return this.vehicleUseType;
	}
	public void setVehicleUseType(String vehicleUseType) {
		this.vehicleUseType = vehicleUseType;
	}

	public String getVin() {
		return this.vin;
	}
	public void setVin(String vin) {
		this.vin = vin;
	}

}
