package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 出租车交易信息回调通知接口
 *
 * @author auto create
 * @since 1.0, 2021-07-01 16:12:42
 */
public class AlipayCommerceTransportTaxiTradeinfoNotifyModel extends AlipayObject {

	private static final long serialVersionUID = 1337978254839623496L;

	/**
	 * 出租车司机身份证号码
	 */
	@ApiField("driver_id_card_no")
	private String driverIdCardNo;

	/**
	 * 出租司机手机号
	 */
	@ApiField("driver_mobile_no")
	private String driverMobileNo;

	/**
	 * 出租车司机姓名
	 */
	@ApiField("driver_name")
	private String driverName;

	/**
	 * 回调所关联操作类型
	 */
	@ApiField("opearate_type")
	private String opearateType;

	/**
	 * 请求时间，Unix Timestamp单位毫秒
	 */
	@ApiField("request_time")
	private String requestTime;

	/**
	 * 交易处理结果
	 */
	@ApiField("result_code")
	private String resultCode;

	/**
	 * 交易处理结果说明
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/**
	 * 支付宝域内唯一司机id
	 */
	@ApiField("sys_driver_id")
	private String sysDriverId;

	public String getDriverIdCardNo() {
		return this.driverIdCardNo;
	}
	public void setDriverIdCardNo(String driverIdCardNo) {
		this.driverIdCardNo = driverIdCardNo;
	}

	public String getDriverMobileNo() {
		return this.driverMobileNo;
	}
	public void setDriverMobileNo(String driverMobileNo) {
		this.driverMobileNo = driverMobileNo;
	}

	public String getDriverName() {
		return this.driverName;
	}
	public void setDriverName(String driverName) {
		this.driverName = driverName;
	}

	public String getOpearateType() {
		return this.opearateType;
	}
	public void setOpearateType(String opearateType) {
		this.opearateType = opearateType;
	}

	public String getRequestTime() {
		return this.requestTime;
	}
	public void setRequestTime(String requestTime) {
		this.requestTime = requestTime;
	}

	public String getResultCode() {
		return this.resultCode;
	}
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getResultMsg() {
		return this.resultMsg;
	}
	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}

	public String getSysDriverId() {
		return this.sysDriverId;
	}
	public void setSysDriverId(String sysDriverId) {
		this.sysDriverId = sysDriverId;
	}

}
