package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 退款申请(车生活订单)
 *
 * @author auto create
 * @since 1.0, 2021-04-22 21:13:13
 */
public class AlipayCommerceTransportVehorderRefundApplyModel extends AlipayObject {

	private static final long serialVersionUID = 1539853666291697121L;

	/**
	 * 支付宝订单号
	 */
	@ApiField("alipay_order_no")
	private String alipayOrderNo;

	/**
	 * 订单类型
VIOLATION-违章查缴
	 */
	@ApiField("order_ype")
	private String orderYpe;

	/**
	 * 订单金额，单位分
	 */
	@ApiField("refund_amount")
	private String refundAmount;

	/**
	 * 退款原因
	 */
	@ApiField("refund_reason")
	private String refundReason;

	/**
	 * 子订单号列表，json字符串数组
	 */
	@ApiField("sub_alipay_order_no_list")
	private String subAlipayOrderNoList;

	/**
	 * 支付宝交易流水号
	 */
	@ApiField("trade_no")
	private String tradeNo;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getAlipayOrderNo() {
		return this.alipayOrderNo;
	}
	public void setAlipayOrderNo(String alipayOrderNo) {
		this.alipayOrderNo = alipayOrderNo;
	}

	public String getOrderYpe() {
		return this.orderYpe;
	}
	public void setOrderYpe(String orderYpe) {
		this.orderYpe = orderYpe;
	}

	public String getRefundAmount() {
		return this.refundAmount;
	}
	public void setRefundAmount(String refundAmount) {
		this.refundAmount = refundAmount;
	}

	public String getRefundReason() {
		return this.refundReason;
	}
	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

	public String getSubAlipayOrderNoList() {
		return this.subAlipayOrderNoList;
	}
	public void setSubAlipayOrderNoList(String subAlipayOrderNoList) {
		this.subAlipayOrderNoList = subAlipayOrderNoList;
	}

	public String getTradeNo() {
		return this.tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
