package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 排班调度-重排班任务
 *
 * @author auto create
 * @since 1.0, 2020-07-08 11:37:52
 */
public class AlipayDataAiserviceCloudbusSchedulereworkAddModel extends AlipayObject {

	private static final long serialVersionUID = 4235521493984749417L;

	/**
	 * 接口版本号  1.0
	 */
	@ApiField("app_version")
	private String appVersion;

	/**
	 * 市
	 */
	@ApiField("city_code")
	private String cityCode;

	/**
	 * 拓展字段
	 */
	@ApiField("ext_param")
	private String extParam;

	/**
	 * 线路id
	 */
	@ApiField("line_id")
	private String lineId;

	/**
	 * 指定原排班结果中的其中一种优化类型
优化目标，0：班次最少；1：工作时长最短；2：等待时间最少；3：工作时长最均匀',
	 */
	@ApiField("optimize_type")
	private String optimizeType;

	/**
	 * 重新排班的时间点  格式 :（时:分:秒）
	 */
	@ApiField("reschedule_time")
	private String rescheduleTime;

	/**
	 * 排班任务依赖的资源id
- "21"对应单程时长
- "22"对应时刻表
- "xx"对应班次运行信息
	 */
	@ApiField("resource_id_dict")
	private String resourceIdDict;

	/**
	 * 重排班任务描述
	 */
	@ApiField("task_name")
	private String taskName;

	/**
	 * 原始排班任务ID
	 */
	@ApiField("work_schedule_task_id")
	private String workScheduleTaskId;

	public String getAppVersion() {
		return this.appVersion;
	}
	public void setAppVersion(String appVersion) {
		this.appVersion = appVersion;
	}

	public String getCityCode() {
		return this.cityCode;
	}
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}

	public String getExtParam() {
		return this.extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}

	public String getLineId() {
		return this.lineId;
	}
	public void setLineId(String lineId) {
		this.lineId = lineId;
	}

	public String getOptimizeType() {
		return this.optimizeType;
	}
	public void setOptimizeType(String optimizeType) {
		this.optimizeType = optimizeType;
	}

	public String getRescheduleTime() {
		return this.rescheduleTime;
	}
	public void setRescheduleTime(String rescheduleTime) {
		this.rescheduleTime = rescheduleTime;
	}

	public String getResourceIdDict() {
		return this.resourceIdDict;
	}
	public void setResourceIdDict(String resourceIdDict) {
		this.resourceIdDict = resourceIdDict;
	}

	public String getTaskName() {
		return this.taskName;
	}
	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getWorkScheduleTaskId() {
		return this.workScheduleTaskId;
	}
	public void setWorkScheduleTaskId(String workScheduleTaskId) {
		this.workScheduleTaskId = workScheduleTaskId;
	}

}
