package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 摩斯产品数据反馈接口
 *
 * @author auto create
 * @since 1.0, 2021-10-13 10:55:31
 */
public class AlipayDataDataexchangeDtmorsepordSyncModel extends AlipayObject {

	private static final long serialVersionUID = 4728987354985197988L;

	/**
	 * 查询的 hash 过的用户ID 列表
	 */
	@ApiListField("anonymous_id_list")
	@ApiField("string")
	private List<String> anonymousIdList;

	/**
	 * 运营人员设置的活动唯一标识，由运营系统产生
	 */
	@ApiField("campaign_id")
	private String campaignId;

	/**
	 * 外部商户发送给域内系统的信息
	 */
	@ApiField("data")
	private String data;

	/**
	 * 目标 ID 一次加密后的密文
	 */
	@ApiField("encrypted_id")
	private String encryptedId;

	/**
	 * 扩展字段，用于补充
	 */
	@ApiField("extent_info")
	private String extentInfo;

	/**
	 * 多方安全计算分配给商户的唯一id，由管理员分配给商户的唯一识别号；
	 */
	@ApiField("mid")
	private String mid;

	/**
	 * 服务操作类型，商户同步信息到域内，类型枚举：sample_init；根据不同场景管理员分配；
	 */
	@ApiField("operate_type")
	private String operateType;

	public List<String> getAnonymousIdList() {
		return this.anonymousIdList;
	}
	public void setAnonymousIdList(List<String> anonymousIdList) {
		this.anonymousIdList = anonymousIdList;
	}

	public String getCampaignId() {
		return this.campaignId;
	}
	public void setCampaignId(String campaignId) {
		this.campaignId = campaignId;
	}

	public String getData() {
		return this.data;
	}
	public void setData(String data) {
		this.data = data;
	}

	public String getEncryptedId() {
		return this.encryptedId;
	}
	public void setEncryptedId(String encryptedId) {
		this.encryptedId = encryptedId;
	}

	public String getExtentInfo() {
		return this.extentInfo;
	}
	public void setExtentInfo(String extentInfo) {
		this.extentInfo = extentInfo;
	}

	public String getMid() {
		return this.mid;
	}
	public void setMid(String mid) {
		this.mid = mid;
	}

	public String getOperateType() {
		return this.operateType;
	}
	public void setOperateType(String operateType) {
		this.operateType = operateType;
	}

}
