package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 行业展台内容查询
 *
 * @author auto create
 * @since 1.0, 2020-01-03 11:35:49
 */
public class AlipayEcoCityservicePolymerDisplayappQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3194141145219529761L;

	/**
	 * 接入的业务主体编码
	 */
	@ApiField("biz_code")
	private String bizCode;

	/**
	 * 前台类目的编码，不传则查询整个区块的内容
	 */
	@ApiField("category_code")
	private String categoryCode;

	/**
	 * 查询树深度。不传则查询整个子树下的内容
	 */
	@ApiField("depth")
	private Long depth;

	/**
	 * 展示区块码
	 */
	@ApiField("display_block_code")
	private String displayBlockCode;

	/**
	 * 聚合主体的内容，为json格式
	 */
	@ApiField("principal_content")
	private String principalContent;

	public String getBizCode() {
		return this.bizCode;
	}
	public void setBizCode(String bizCode) {
		this.bizCode = bizCode;
	}

	public String getCategoryCode() {
		return this.categoryCode;
	}
	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public Long getDepth() {
		return this.depth;
	}
	public void setDepth(Long depth) {
		this.depth = depth;
	}

	public String getDisplayBlockCode() {
		return this.displayBlockCode;
	}
	public void setDisplayBlockCode(String displayBlockCode) {
		this.displayBlockCode = displayBlockCode;
	}

	public String getPrincipalContent() {
		return this.principalContent;
	}
	public void setPrincipalContent(String principalContent) {
		this.principalContent = principalContent;
	}

}
