package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 资金资产服务创建订单并推进
 *
 * @author auto create
 * @since 1.0, 2021-06-30 10:41:59
 */
public class AlipayFincoreFascoreCreateandpayModel extends AlipayObject {

	private static final long serialVersionUID = 3891978238126814375L;

	/**
	 * 资产相关json对象,参见assetDTO
	 */
	@ApiField("asset_dto")
	private String assetDto;

	/**
	 * 定义业务场景的对象,包括扩展业务能力
	 */
	@ApiField("business_identity")
	private String businessIdentity;

	/**
	 * 访问渠道
	 */
	@ApiField("channel")
	private String channel;

	/**
	 * 扩展属性
	 */
	@ApiField("ext_info_map")
	private String extInfoMap;

	/**
	 * 阶段资金资产服务主单号
	 */
	@ApiField("master_order_no")
	private String masterOrderNo;

	/**
	 * 订单备注
	 */
	@ApiField("order_desc")
	private String orderDesc;

	/**
	 * 订单超时时间。在超时后，如果订单已经支付成功，将订单状态推进为FINISH，此时不可再退款；
如果订单未支付或者支付失败，将订单状态推进为CLOSE，此时订单不可再次支付 默认为1天后关闭
最大不超过366天
	 */
	@ApiField("order_timeout")
	private Date orderTimeout;

	/**
	 * 订单标题
	 */
	@ApiField("order_title")
	private String orderTitle;

	/**
	 * 外部订单号
	 */
	@ApiField("out_order_no")
	private String outOrderNo;

	/**
	 * 外部请求号
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 商户ID
	 */
	@ApiField("partner_user_id")
	private String partnerUserId;

	/**
	 * 支付信息,json格式
	 */
	@ApiField("payment_info_dto")
	private String paymentInfoDto;

	/**
	 * 业务平台
	 */
	@ApiField("platform")
	private String platform;

	/**
	 * 业务主体uid（用于LDC策略分库分表依据），一般场景下无需设置，除非有特殊需求
	 */
	@ApiField("principal_id")
	private String principalId;

	/**
	 * 即时资金资产服务
	 */
	@ApiField("product_code")
	private String productCode;

	public String getAssetDto() {
		return this.assetDto;
	}
	public void setAssetDto(String assetDto) {
		this.assetDto = assetDto;
	}

	public String getBusinessIdentity() {
		return this.businessIdentity;
	}
	public void setBusinessIdentity(String businessIdentity) {
		this.businessIdentity = businessIdentity;
	}

	public String getChannel() {
		return this.channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getExtInfoMap() {
		return this.extInfoMap;
	}
	public void setExtInfoMap(String extInfoMap) {
		this.extInfoMap = extInfoMap;
	}

	public String getMasterOrderNo() {
		return this.masterOrderNo;
	}
	public void setMasterOrderNo(String masterOrderNo) {
		this.masterOrderNo = masterOrderNo;
	}

	public String getOrderDesc() {
		return this.orderDesc;
	}
	public void setOrderDesc(String orderDesc) {
		this.orderDesc = orderDesc;
	}

	public Date getOrderTimeout() {
		return this.orderTimeout;
	}
	public void setOrderTimeout(Date orderTimeout) {
		this.orderTimeout = orderTimeout;
	}

	public String getOrderTitle() {
		return this.orderTitle;
	}
	public void setOrderTitle(String orderTitle) {
		this.orderTitle = orderTitle;
	}

	public String getOutOrderNo() {
		return this.outOrderNo;
	}
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getPartnerUserId() {
		return this.partnerUserId;
	}
	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public String getPaymentInfoDto() {
		return this.paymentInfoDto;
	}
	public void setPaymentInfoDto(String paymentInfoDto) {
		this.paymentInfoDto = paymentInfoDto;
	}

	public String getPlatform() {
		return this.platform;
	}
	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public String getPrincipalId() {
		return this.principalId;
	}
	public void setPrincipalId(String principalId) {
		this.principalId = principalId;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

}
