package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 结算卡开通页面接口
 *
 * @author auto create
 * @since 1.0, 2020-12-17 16:52:37
 */
public class AlipayFundInstcardPageSignModel extends AlipayObject {

	private static final long serialVersionUID = 7243179931622954133L;

	/**
	 * 描述特定的业务场景
	 */
	@ApiField("biz_scene")
	private String bizScene;

	/**
	 * 用户实名信息参数，包含：姓名、身份证号。商户传入用户实名信息参数，支付宝会对比用户在支付宝端的实名信息。
	 */
	@ApiField("identity_params")
	private FundIdentityParams identityParams;

	/**
	 * 销售产品码，商户签约的支付宝合同所对应的产品码。
	 */
	@ApiField("product_code")
	private String productCode;

	/**
	 * 间连场景填写商户收单smid
	 */
	@ApiField("smid")
	private String smid;

	public String getBizScene() {
		return this.bizScene;
	}
	public void setBizScene(String bizScene) {
		this.bizScene = bizScene;
	}

	public FundIdentityParams getIdentityParams() {
		return this.identityParams;
	}
	public void setIdentityParams(FundIdentityParams identityParams) {
		this.identityParams = identityParams;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getSmid() {
		return this.smid;
	}
	public void setSmid(String smid) {
		this.smid = smid;
	}

}
