package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 商户结算卡查询
 *
 * @author auto create
 * @since 1.0, 2020-12-17 22:19:40
 */
public class AlipayFundInstcardSignQueryModel extends AlipayObject {

	private static final long serialVersionUID = 2622444957295972611L;

	/**
	 * 业务场景
	 */
	@ApiField("biz_scene")
	private String bizScene;

	/**
	 * 用户信息参数
	 */
	@ApiField("fund_identity_params")
	private FundIdentityParams fundIdentityParams;

	/**
	 * 销售产品码
	 */
	@ApiField("product_code")
	private String productCode;

	/**
	 * 入驻成功后支付宝返回受理商户唯一标识（sub_merchant_id简称smid）
	 */
	@ApiField("smid")
	private String smid;

	public String getBizScene() {
		return this.bizScene;
	}
	public void setBizScene(String bizScene) {
		this.bizScene = bizScene;
	}

	public FundIdentityParams getFundIdentityParams() {
		return this.fundIdentityParams;
	}
	public void setFundIdentityParams(FundIdentityParams fundIdentityParams) {
		this.fundIdentityParams = fundIdentityParams;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getSmid() {
		return this.smid;
	}
	public void setSmid(String smid) {
		this.smid = smid;
	}

}
