package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 上传智能外呼用户号码
 *
 * @author auto create
 * @since 1.0, 2021-02-07 16:21:40
 */
public class AlipayIserviceCcmOutboundphoneUploadModel extends AlipayObject {

	private static final long serialVersionUID = 2466887755651742239L;

	/**
	 * 号码外呼的过期时间，超过这个时间就不进行外呼
	 */
	@ApiField("expiration_time")
	private Date expirationTime;

	/**
	 * 号码外呼开始的时间
	 */
	@ApiField("outcall_start_time")
	private Date outcallStartTime;

	/**
	 * 待外呼的用户信息列表
	 */
	@ApiListField("outcall_users")
	@ApiField("outcall_user_v_o")
	private List<OutcallUserVO> outcallUsers;

	/**
	 * 租户在CCM的智能外呼系统上，创建的外呼任务编码
	 */
	@ApiField("task_code")
	private String taskCode;

	public Date getExpirationTime() {
		return this.expirationTime;
	}
	public void setExpirationTime(Date expirationTime) {
		this.expirationTime = expirationTime;
	}

	public Date getOutcallStartTime() {
		return this.outcallStartTime;
	}
	public void setOutcallStartTime(Date outcallStartTime) {
		this.outcallStartTime = outcallStartTime;
	}

	public List<OutcallUserVO> getOutcallUsers() {
		return this.outcallUsers;
	}
	public void setOutcallUsers(List<OutcallUserVO> outcallUsers) {
		this.outcallUsers = outcallUsers;
	}

	public String getTaskCode() {
		return this.taskCode;
	}
	public void setTaskCode(String taskCode) {
		this.taskCode = taskCode;
	}

}
