package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 根据条件查询服务记录
 *
 * @author auto create
 * @since 1.0, 2021-05-21 14:35:54
 */
public class AlipayIserviceCcmServicerecordQueryModel extends AlipayObject {

	private static final long serialVersionUID = 2394389786953816564L;

	/**
	 * 租户实例id（数据权限id）
	 */
	@ApiField("ccs_instance_id")
	private String ccsInstanceId;

	/**
	 * 查询结束时间，可为空，采用UTC时间，按照ISO8601标准表示，格式为：yyyy-MM-DDThh:mm:ssZ
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 查询页码
	 */
	@ApiField("page_num")
	private Long pageNum;

	/**
	 * 分页查询每页条数
	 */
	@ApiField("page_size")
	private Long pageSize;

	/**
	 * 该通服务的场景id，可能为空
	 */
	@ApiField("scene_id")
	private String sceneId;

	/**
	 * 查询开始时间，采用UTC时间，按照ISO8601标准表示
	 */
	@ApiField("start_time")
	private Date startTime;

	/**
	 * 访客的id，非云客服的id，由调用方定义
	 */
	@ApiField("visitor_id")
	private String visitorId;

	/**
	 * 访客地区
	 */
	@ApiField("visitor_province")
	private String visitorProvince;

	public String getCcsInstanceId() {
		return this.ccsInstanceId;
	}
	public void setCcsInstanceId(String ccsInstanceId) {
		this.ccsInstanceId = ccsInstanceId;
	}

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Long getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public String getSceneId() {
		return this.sceneId;
	}
	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}

	public Date getStartTime() {
		return this.startTime;
	}
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public String getVisitorId() {
		return this.visitorId;
	}
	public void setVisitorId(String visitorId) {
		this.visitorId = visitorId;
	}

	public String getVisitorProvince() {
		return this.visitorProvince;
	}
	public void setVisitorProvince(String visitorProvince) {
		this.visitorProvince = visitorProvince;
	}

}
