package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 创建投放
 *
 * @author auto create
 * @since 1.0, 2021-12-15 21:42:56
 */
public class AlipayMarketingActivityUpgradedeliveryCreateModel extends AlipayObject {

	private static final long serialVersionUID = 4247263256361882551L;

	/**
	 * 展位编码。

枚举值：
PAY_RESULT：本店投放
NEARBY_RESULT：附近发券
BRAND_BOX：品牌box

不同展位对应不同的投放玩法与规则。确定booth_code后，请仔细查看后续字段说明.
	 */
	@ApiField("booth_code")
	private String boothCode;

	/**
	 * 投放基础信息。主要包含投放时间、投放素材等。
	 */
	@ApiField("delivery_base_info")
	private DeliveryBaseInfo deliveryBaseInfo;

	/**
	 * 投放玩法配置。例如：支付后满门槛送券。 投放玩法配置与展位编码booth_code相关。不同的booth_code能够配置的玩法不同。

限制：投放玩法配置，只允许在下面的选项中多选一。
	 */
	@ApiField("delivery_play_config")
	private DeliveryPlayConfig deliveryPlayConfig;

	/**
	 * 投放定向规则。

说明：进一步针对本次投放进行规则限制。
例如：可曝光的商户信息。
	 */
	@ApiField("delivery_target_rule")
	private DeliveryTargetRule deliveryTargetRule;

	public String getBoothCode() {
		return this.boothCode;
	}
	public void setBoothCode(String boothCode) {
		this.boothCode = boothCode;
	}

	public DeliveryBaseInfo getDeliveryBaseInfo() {
		return this.deliveryBaseInfo;
	}
	public void setDeliveryBaseInfo(DeliveryBaseInfo deliveryBaseInfo) {
		this.deliveryBaseInfo = deliveryBaseInfo;
	}

	public DeliveryPlayConfig getDeliveryPlayConfig() {
		return this.deliveryPlayConfig;
	}
	public void setDeliveryPlayConfig(DeliveryPlayConfig deliveryPlayConfig) {
		this.deliveryPlayConfig = deliveryPlayConfig;
	}

	public DeliveryTargetRule getDeliveryTargetRule() {
		return this.deliveryTargetRule;
	}
	public void setDeliveryTargetRule(DeliveryTargetRule deliveryTargetRule) {
		this.deliveryTargetRule = deliveryTargetRule;
	}

}
