package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 二方机构根标签据查询有效券信息
 *
 * @author auto create
 * @since 1.0, 2020-06-15 11:54:45
 */
public class AlipayMarketingVoucherBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 2849253572667613232L;

	/**
	 * 资产编码
	 */
	@ApiField("assets_code")
	private String assetsCode;

	/**
	 * 券业务编码
	 */
	@ApiField("biz_codes")
	private String bizCodes;

	/**
	 * 创建结束时间
	 */
	@ApiField("create_end_time")
	private Date createEndTime;

	/**
	 * 创建券的开始时间
	 */
	@ApiField("create_start_time")
	private Date createStartTime;

	/**
	 * 当前页数
	 */
	@ApiField("page_num")
	private String pageNum;

	/**
	 * 每页显示条数
	 */
	@ApiField("page_size")
	private String pageSize;

	/**
	 * 券资产编码列表
	 */
	@ApiField("product_codes")
	private String productCodes;

	/**
	 * ENABLED查询可用券
	 */
	@ApiField("status_list")
	private String statusList;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_info")
	private String userInfo;

	/**
	 * key:value,如果根据tag标签查询，则传{"tag":["hz_tongyong"]}
	 */
	@ApiField("voucher_extend_info")
	private String voucherExtendInfo;

	public String getAssetsCode() {
		return this.assetsCode;
	}
	public void setAssetsCode(String assetsCode) {
		this.assetsCode = assetsCode;
	}

	public String getBizCodes() {
		return this.bizCodes;
	}
	public void setBizCodes(String bizCodes) {
		this.bizCodes = bizCodes;
	}

	public Date getCreateEndTime() {
		return this.createEndTime;
	}
	public void setCreateEndTime(Date createEndTime) {
		this.createEndTime = createEndTime;
	}

	public Date getCreateStartTime() {
		return this.createStartTime;
	}
	public void setCreateStartTime(Date createStartTime) {
		this.createStartTime = createStartTime;
	}

	public String getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(String pageNum) {
		this.pageNum = pageNum;
	}

	public String getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}

	public String getProductCodes() {
		return this.productCodes;
	}
	public void setProductCodes(String productCodes) {
		this.productCodes = productCodes;
	}

	public String getStatusList() {
		return this.statusList;
	}
	public void setStatusList(String statusList) {
		this.statusList = statusList;
	}

	public String getUserInfo() {
		return this.userInfo;
	}
	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}

	public String getVoucherExtendInfo() {
		return this.voucherExtendInfo;
	}
	public void setVoucherExtendInfo(String voucherExtendInfo) {
		this.voucherExtendInfo = voucherExtendInfo;
	}

}
