package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 应用基础POI绑定
 *
 * @author auto create
 * @since 1.0, 2020-07-07 13:46:18
 */
public class AlipayOpenAppAppbaseShopdemoBindModel extends AlipayObject {

	private static final long serialVersionUID = 1458743693515384561L;

	/**
	 * 门店ID列表，ID内容与对应类型shop_type保持一致
	 */
	@ApiField("shop_id_list")
	private String shopIdList;

	/**
	 * 门店数据类型
MERCHANT_POI：商户侧渠道POI，对应商户合作门店，通过应用内容POI接口上传到支付宝
ALIPAY_SHOP: 支付宝标准门店，对应商户直营/加盟门店，通过支付宝门店接口创建获得
	 */
	@ApiField("shop_type")
	private String shopType;

	public String getShopIdList() {
		return this.shopIdList;
	}
	public void setShopIdList(String shopIdList) {
		this.shopIdList = shopIdList;
	}

	public String getShopType() {
		return this.shopType;
	}
	public void setShopType(String shopType) {
		this.shopType = shopType;
	}

}
