package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 小程序内容分页查询绑定关系
 *
 * @author auto create
 * @since 1.0, 2020-07-23 19:13:00
 */
public class AlipayOpenAppContentRelationBatchqueryModel extends AlipayObject {

	private static final long serialVersionUID = 1626925394951895737L;

	/**
	 * 被绑定的实体类型，包括：支付宝商品、支付宝门店、商家POI、高德POI。对应枚举为：ALIPAY_ITEM、ALIPAY_SHOP、MERCHANT_POI、AMAP_POI
	 */
	@ApiField("bind_content_type")
	private String bindContentType;

	/**
	 * 绑定类型：小程序绑定门店、服务绑定门店、商品绑定门店、服务绑定商品。对应的枚举类型为：MINI_APP_BIND_SHOP、FUNCTION_BIND_SHOP、ITEM_BIND_SHOP、FUNCTION_BIND_ITEM
	 */
	@ApiField("bind_type")
	private String bindType;

	/**
	 * 进行绑定操作的实体编码：小程序绑定门店，content_id为该小程序编码；服务绑定门店或服务绑定商品，content_id为该服务的编码；商品绑定门店，content_id为该商品的编码
	 */
	@ApiField("content_id")
	private String contentId;

	/**
	 * 当前页码
	 */
	@ApiField("page_num")
	private Long pageNum;

	/**
	 * 分页查询中每一页的查询数量，最大限制为50
	 */
	@ApiField("page_size")
	private Long pageSize;

	public String getBindContentType() {
		return this.bindContentType;
	}
	public void setBindContentType(String bindContentType) {
		this.bindContentType = bindContentType;
	}

	public String getBindType() {
		return this.bindType;
	}
	public void setBindType(String bindType) {
		this.bindType = bindType;
	}

	public String getContentId() {
		return this.contentId;
	}
	public void setContentId(String contentId) {
		this.contentId = contentId;
	}

	public Long getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

}
