package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 模板继承化小程序灰度升级
 *
 * @author auto create
 * @since 1.0, 2021-10-18 11:08:32
 */
public class AlipayOpenMiniTemplateGrayUpgradeModel extends AlipayObject {

	private static final long serialVersionUID = 8663351813266464539L;

	/**
	 * 接入的端
	 */
	@ApiField("app_origin")
	private String appOrigin;

	/**
	 * 端id
	 */
	@ApiField("bundle_id")
	private String bundleId;

	/**
	 * APP_PERCENTAGE:app维度百分比
USER_PERCENTAGE:用户维度百分比
	 */
	@ApiField("gray_strategy")
	private String grayStrategy;

	/**
	 * 灰度值，例如30代表30%
	 */
	@ApiField("gray_value")
	private String grayValue;

	/**
	 * 操作人id，用于记录操作人
	 */
	@ApiField("operator_id")
	private String operatorId;

	/**
	 * 模板appId
	 */
	@ApiField("template_app_id")
	private String templateAppId;

	/**
	 * 模板版本
	 */
	@ApiField("template_version")
	private String templateVersion;

	public String getAppOrigin() {
		return this.appOrigin;
	}
	public void setAppOrigin(String appOrigin) {
		this.appOrigin = appOrigin;
	}

	public String getBundleId() {
		return this.bundleId;
	}
	public void setBundleId(String bundleId) {
		this.bundleId = bundleId;
	}

	public String getGrayStrategy() {
		return this.grayStrategy;
	}
	public void setGrayStrategy(String grayStrategy) {
		this.grayStrategy = grayStrategy;
	}

	public String getGrayValue() {
		return this.grayValue;
	}
	public void setGrayValue(String grayValue) {
		this.grayValue = grayValue;
	}

	public String getOperatorId() {
		return this.operatorId;
	}
	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getTemplateAppId() {
		return this.templateAppId;
	}
	public void setTemplateAppId(String templateAppId) {
		this.templateAppId = templateAppId;
	}

	public String getTemplateVersion() {
		return this.templateVersion;
	}
	public void setTemplateVersion(String templateVersion) {
		this.templateVersion = templateVersion;
	}

}
