package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 *  产品管理令牌与核身标识申请
 *
 * @author auto create
 * @since 1.0, 2020-07-23 11:11:57
 */
public class AlipaySecurityProdIotVerifyApplyModel extends AlipayObject {

	private static final long serialVersionUID = 6643921566956627651L;

	/**
	 * 设备标识，api使用方系统内部定义的设备标识，需要保证这个设备标识在api使用方系统的唯一性。
	 */
	@ApiField("device_id")
	private String deviceId;

	/**
	 * api使用方用户身份标识，可以是蚂蚁的统一用户身份标识也可以是api使用方系统自定义的用户身份标识，需要保证这个身份标识在api使用方系统的唯一性。
	 */
	@ApiField("external_user_id")
	private String externalUserId;

	/**
	 * 操作类，标识当前申请的令牌用于哪种操作，当前支持的操作类型有： 产品开通：200 产品关闭：201 产品更新：202 执行校验：203
	 */
	@ApiField("opt_type")
	private Long optType;

	/**
	 * 如果产品开通场景需要将此参数传入，如果是在校验场景则此参数为空。
	 */
	@ApiField("product_id")
	private String productId;

	/**
	 * 场景标识，用于区分当前api使用方是在什么场景下使用此api，api使用方在api接入前需要联系蚂蚁业务pd进行本参数的申请。
	 */
	@ApiField("scene_id")
	private String sceneId;

	public String getDeviceId() {
		return this.deviceId;
	}
	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getExternalUserId() {
		return this.externalUserId;
	}
	public void setExternalUserId(String externalUserId) {
		this.externalUserId = externalUserId;
	}

	public Long getOptType() {
		return this.optType;
	}
	public void setOptType(Long optType) {
		this.optType = optType;
	}

	public String getProductId() {
		return this.productId;
	}
	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getSceneId() {
		return this.sceneId;
	}
	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}

}
