package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * IoT核身产品开通与执行通用接口
 *
 * @author auto create
 * @since 1.0, 2020-07-23 11:11:32
 */
public class AlipaySecurityProdIotVerifyCreateModel extends AlipayObject {

	private static final long serialVersionUID = 1195381452119172419L;

	/**
	 * 设备标识，api使用方系统内部定义的设备标识，需要保证这个设备标识在api使用方系统的唯一性。
	 */
	@ApiField("device_id")
	private String deviceId;

	/**
	 * api使用方用户身份标识，可以是蚂蚁的统一用户身份标识也可以是api使用方系统自定义的用户身份标识，需要保证这个身份标识在api使用方系统的唯一性。
	 */
	@ApiField("external_user_id")
	private String externalUserId;

	/**
	 * 操作流水号，用于本次流程执行中多次交互的唯一标识，api使用方在执行此api前需要调用蚂蚁提供的申请接口进行分配。
	 */
	@ApiField("opt_flow_id")
	private String optFlowId;

	/**
	 * 操作类型，标识本次操作的类型，当前支持的操作类型有：
产品开通：200
产品关闭：201
产品更新：202
执行校验：203
	 */
	@ApiField("opt_type")
	private Long optType;

	/**
	 * 操作参数，由于本api属于多次交互api，需要在不同子操作类型中定义不同的交互参数，故采用json格式进行操作参数的传递，本字段为json格式的字符串。
	 */
	@ApiField("request_params")
	private String requestParams;

	/**
	 * 场景标识，用于区分当前api使用方是在什么场景下使用此api，api使用方在api接入前需要联系蚂蚁业务pd进行本参数的申请。
	 */
	@ApiField("scene_id")
	private String sceneId;

	/**
	 * 子操作类型，标识当前流程执行到哪一步骤,当前api属于多次交互api，子操作类型由上一次调用蚂蚁本api所返回，用于引导下一次交互，当前支持的子操作类型有：
环境检测：301
环境检测报告:302
声纹注册首次渲染：303
声纹注册首次渲染报告：304
声纹注册二次渲染：305
声纹注册二次渲染报告：306
校验声纹渲染：307
校验声纹渲染报告：308
更新声纹产品状态：309
	 */
	@ApiField("sub_opt_type")
	private Long subOptType;

	public String getDeviceId() {
		return this.deviceId;
	}
	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getExternalUserId() {
		return this.externalUserId;
	}
	public void setExternalUserId(String externalUserId) {
		this.externalUserId = externalUserId;
	}

	public String getOptFlowId() {
		return this.optFlowId;
	}
	public void setOptFlowId(String optFlowId) {
		this.optFlowId = optFlowId;
	}

	public Long getOptType() {
		return this.optType;
	}
	public void setOptType(Long optType) {
		this.optType = optType;
	}

	public String getRequestParams() {
		return this.requestParams;
	}
	public void setRequestParams(String requestParams) {
		this.requestParams = requestParams;
	}

	public String getSceneId() {
		return this.sceneId;
	}
	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}

	public Long getSubOptType() {
		return this.subOptType;
	}
	public void setSubOptType(Long subOptType) {
		this.subOptType = subOptType;
	}

}
