package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 淘宝处罚结果核对
 *
 * @author auto create
 * @since 1.0, 2020-06-28 20:05:10
 */
public class AlipaySecurityRiskTaobaopunishResultcheckQueryModel extends AlipayObject {

	private static final long serialVersionUID = 2284996191992724257L;

	/**
	 * 执行的动作，PUNISH：执行处罚；RELIEVE：解除处罚
	 */
	@ApiField("action_type")
	private String actionType;

	/**
	 * 处罚执行参数，用于执行属性的校验，格式为“属性名：属性值”，视不同的处罚策略需要的属性会有不同，由双方技术同学协商确定
	 */
	@ApiListField("biz_param")
	@ApiField("string")
	private List<String> bizParam;

	/**
	 * 校验的阶段，用于多阶段的校验，1: 校验一阶段；2: 校验二阶段，一阶段返回处罚DB的一致性，二阶段用于返回实际打标结果的一致性
	 */
	@ApiField("phase")
	private String phase;

	/**
	 * 支付宝处罚的任务ID，用于核对时找到对应的任务，从集团请求中获取，处罚时传单个，解除处罚可能传多个任务ID
	 */
	@ApiListField("punish_ids")
	@ApiField("string")
	private List<String> punishIds;

	/**
	 * 服务执行是否成功，SUCCESS: 成功；BIZ_FAIL：业务失败；SERVICE_FAIL：服务调用失败
	 */
	@ApiField("result")
	private String result;

	/**
	 * 处罚的策略名称, 用于核对时比对策略信息，仅当执行处罚动作时传入
	 */
	@ApiField("strategy_name")
	private String strategyName;

	/**
	 * 处罚用户账号，用于在核对时获取用户的处罚记录，从集团请求中获取
	 */
	@ApiField("user_id")
	private String userId;

	public String getActionType() {
		return this.actionType;
	}
	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

	public List<String> getBizParam() {
		return this.bizParam;
	}
	public void setBizParam(List<String> bizParam) {
		this.bizParam = bizParam;
	}

	public String getPhase() {
		return this.phase;
	}
	public void setPhase(String phase) {
		this.phase = phase;
	}

	public List<String> getPunishIds() {
		return this.punishIds;
	}
	public void setPunishIds(List<String> punishIds) {
		this.punishIds = punishIds;
	}

	public String getResult() {
		return this.result;
	}
	public void setResult(String result) {
		this.result = result;
	}

	public String getStrategyName() {
		return this.strategyName;
	}
	public void setStrategyName(String strategyName) {
		this.strategyName = strategyName;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
