package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 分组消息群发
 *
 * @author auto create
 * @since 1.0, 2021-12-10 11:52:59
 */
public class AlipaySocialBaseBcClustermsgSendModel extends AlipayObject {

	private static final long serialVersionUID = 3341717513894822568L;

	/**
	 * 是否at所有人
	 */
	@ApiField("at_all")
	private Boolean atAll;

	/**
	 * 业务方id，消息发送时可传入，消息列表返回
	 */
	@ApiField("biz_id")
	private String bizId;

	/**
	 * 客户群分组id，此id唯一，分组下会管理一系列的客户群
	 */
	@ApiListField("cluster_ids")
	@ApiField("string")
	private List<String> clusterIds;

	/**
	 * 分组发消息名称
	 */
	@ApiField("msg_name")
	private String msgName;

	/**
	 * 发送模板code，可选以下值 TEXT,IMAGE,LINKS,MINIAPP
	 */
	@ApiField("template_code")
	private String templateCode;

	/**
	 * 消息内容json，可反序列化为TextTemplateData、ImageTemplateData、LinksTemplateData和MiniAppTemplateData等
	 */
	@ApiField("template_data")
	private String templateData;

	/**
	 * 客户群业务租户id，比如生态商家此id为7，b站开通商户为18
	 */
	@ApiField("tenant_id")
	private String tenantId;

	public Boolean getAtAll() {
		return this.atAll;
	}
	public void setAtAll(Boolean atAll) {
		this.atAll = atAll;
	}

	public String getBizId() {
		return this.bizId;
	}
	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public List<String> getClusterIds() {
		return this.clusterIds;
	}
	public void setClusterIds(List<String> clusterIds) {
		this.clusterIds = clusterIds;
	}

	public String getMsgName() {
		return this.msgName;
	}
	public void setMsgName(String msgName) {
		this.msgName = msgName;
	}

	public String getTemplateCode() {
		return this.templateCode;
	}
	public void setTemplateCode(String templateCode) {
		this.templateCode = templateCode;
	}

	public String getTemplateData() {
		return this.templateData;
	}
	public void setTemplateData(String templateData) {
		this.templateData = templateData;
	}

	public String getTenantId() {
		return this.tenantId;
	}
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

}
