package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 设置群欢迎语及群公告等其他设置
 *
 * @author auto create
 * @since 1.0, 2021-12-10 11:58:50
 */
public class AlipaySocialBaseBcClustersettingModifyModel extends AlipayObject {

	private static final long serialVersionUID = 2835231411399511748L;

	/**
	 * 客户群分组id，此id唯一，分组下会管理一系列的客户群
	 */
	@ApiField("cluster_id")
	private String clusterId;

	/**
	 * 分组设置详情；key可选【NOTICE(公告)、WELCOME(欢迎语)】
	 */
	@ApiListField("cluster_settings")
	@ApiField("cluster_setting")
	private List<ClusterSetting> clusterSettings;

	/**
	 * 客户群业务租户id，比如生态商家此id为7，b站开通商户为18
	 */
	@ApiField("tenant_id")
	private String tenantId;

	public String getClusterId() {
		return this.clusterId;
	}
	public void setClusterId(String clusterId) {
		this.clusterId = clusterId;
	}

	public List<ClusterSetting> getClusterSettings() {
		return this.clusterSettings;
	}
	public void setClusterSettings(List<ClusterSetting> clusterSettings) {
		this.clusterSettings = clusterSettings;
	}

	public String getTenantId() {
		return this.tenantId;
	}
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

}
