package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * BC互动创建BC会话关系
 *
 * @author auto create
 * @since 1.0, 2021-08-17 10:42:34
 */
public class AlipaySocialBaseBcRelationCreateModel extends AlipayObject {

	private static final long serialVersionUID = 1284121355819637424L;

	/**
	 * BC互动中，查询顶部通栏时的操作者视角，枚举为： C端视角传1 B端视角传2
	 */
	@ApiField("bc_role_type")
	private String bcRoleType;

	/**
	 * 业务类型，接入时由社交侧分配
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * BC互动中的B端ID，为业务方内部标识唯一B端帐号的id，如B端为商家，则为商家唯一ID
	 */
	@ApiField("business_id")
	private String businessId;

	/**
	 * 其他业务相关的附加参数
	 */
	@ApiField("ext_info_map")
	private String extInfoMap;

	/**
	 * BC互动中的B端类型，每个不同业务对应一个type，在接入时由社交侧开放进行分配，对单个业务来说是固定值
	 */
	@ApiField("relation_type")
	private String relationType;

	/**
	 * 创建关系的入口来源标识，仅用于统计，如不传则默认为0
	 */
	@ApiField("source")
	private Long source;

	/**
	 * BC互动中的C端ID，为支付宝统一用户userId
	 */
	@ApiField("user_id")
	private String userId;

	public String getBcRoleType() {
		return this.bcRoleType;
	}
	public void setBcRoleType(String bcRoleType) {
		this.bcRoleType = bcRoleType;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBusinessId() {
		return this.businessId;
	}
	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getExtInfoMap() {
		return this.extInfoMap;
	}
	public void setExtInfoMap(String extInfoMap) {
		this.extInfoMap = extInfoMap;
	}

	public String getRelationType() {
		return this.relationType;
	}
	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public Long getSource() {
		return this.source;
	}
	public void setSource(Long source) {
		this.source = source;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
