package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 获取好友列表信息
 *
 * @author auto create
 * @since 1.0, 2021-05-21 17:14:53
 */
public class AlipaySocialBaseRelationFriendsQueryModel extends AlipayObject {

	private static final long serialVersionUID = 1343721685579235412L;

	/**
	 * 获取类型。1=获取双向好友   2=获取双向+单向好友
	 */
	@ApiField("get_type")
	private Long getType;

	/**
	 * 好友列表中是否返回自己， true=返回   false=不返回    默认false
	 */
	@ApiField("include_self")
	private Boolean includeSelf;

	/**
	 * 上一页的最后一个uid
	 */
	@ApiField("last_user_id")
	private String lastUserId;

	/**
	 * 分页大小
	 */
	@ApiField("page_size")
	private Long pageSize;

	public Long getGetType() {
		return this.getType;
	}
	public void setGetType(Long getType) {
		this.getType = getType;
	}

	public Boolean getIncludeSelf() {
		return this.includeSelf;
	}
	public void setIncludeSelf(Boolean includeSelf) {
		this.includeSelf = includeSelf;
	}

	public String getLastUserId() {
		return this.lastUserId;
	}
	public void setLastUserId(String lastUserId) {
		this.lastUserId = lastUserId;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

}
