package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝用户增长产品订单确认
 *
 * @author auto create
 * @since 1.0, 2021-09-16 14:48:46
 */
public class AlipayUserUgrowthprodOrderFinishModel extends AlipayObject {

	private static final long serialVersionUID = 1347512559879947597L;

	/**
	 * 用户增长产品订单号
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 外部业务时间（格式：yyyy-MM-dd HH:mm:ss）
	 */
	@ApiField("out_biz_date")
	private String outBizDate;

	/**
	 * 代表了一次请求，作为业务幂等性控制
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 外部业务单号
	 */
	@ApiField("out_trade_no")
	private String outTradeNo;

	/**
	 * 用户增长产品外部卖家id(接口联调阶段每个卖家固定分配值，shihuituan：十荟团)
	 */
	@ApiField("seller_id")
	private String sellerId;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutBizDate() {
		return this.outBizDate;
	}
	public void setOutBizDate(String outBizDate) {
		this.outBizDate = outBizDate;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getOutTradeNo() {
		return this.outTradeNo;
	}
	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getSellerId() {
		return this.sellerId;
	}
	public void setSellerId(String sellerId) {
		this.sellerId = sellerId;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
