package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝用户增长产品转化类任务完成通知
 *
 * @author auto create
 * @since 1.0, 2021-09-17 15:53:32
 */
public class AlipayUserUgrowthprodOrderNotifyModel extends AlipayObject {

	private static final long serialVersionUID = 1479897236641464723L;

	/**
	 * 业务来源（对应到外部调用方标识，SHT:十荟团）
	 */
	@ApiField("biz_source")
	private String bizSource;

	/**
	 * 菜园内部订单号（十荟团兑换链路必传）
	 */
	@ApiField("in_order_id")
	private String inOrderId;

	/**
	 * 订单动作（FINISH：完成，CANCLE：取消）
	 */
	@ApiField("order_action")
	private String orderAction;

	/**
	 * 订单类型，用于区分是0元单还是正常任务单。
FREE_ORDER:0元单
NORMAL_ORDER:正常任务单
	 */
	@ApiField("order_type")
	private String orderType;

	/**
	 * 外部业务时间（格式：yyyy-MM-dd HH:mm:ss）
	 */
	@ApiField("out_biz_date")
	private String outBizDate;

	/**
	 * 外部订单号（十荟团主订单号）
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 外部请求号
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getBizSource() {
		return this.bizSource;
	}
	public void setBizSource(String bizSource) {
		this.bizSource = bizSource;
	}

	public String getInOrderId() {
		return this.inOrderId;
	}
	public void setInOrderId(String inOrderId) {
		this.inOrderId = inOrderId;
	}

	public String getOrderAction() {
		return this.orderAction;
	}
	public void setOrderAction(String orderAction) {
		this.orderAction = orderAction;
	}

	public String getOrderType() {
		return this.orderType;
	}
	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	public String getOutBizDate() {
		return this.outBizDate;
	}
	public void setOutBizDate(String outBizDate) {
		this.outBizDate = outBizDate;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
