package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝用户增长产品订单支付
 *
 * @author auto create
 * @since 1.0, 2021-09-17 15:32:31
 */
public class AlipayUserUgrowthprodOrderPayModel extends AlipayObject {

	private static final long serialVersionUID = 4514467891289149933L;

	/**
	 * 卖家商品id（菜园跳转十荟团下单确认页时参数传递透传）
	 */
	@ApiField("goods_id")
	private String goodsId;

	/**
	 * 用户增长产品订单号（菜园跳转十荟团下单确认页时参数传递）
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 外部业务时间（格式：yyyy-MM-dd HH:mm:ss）
	 */
	@ApiField("out_biz_date")
	private String outBizDate;

	/**
	 * 代表了一次请求，作为业务幂等性控制
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 卖家商品数量（菜园跳转十荟团下单确认页时参数传递）
	 */
	@ApiField("quantity")
	private String quantity;

	/**
	 * 用户增长产品外部卖家id（接口联调阶段每个卖家固定分配值，SHT：十荟团）
	 */
	@ApiField("seller_id")
	private String sellerId;

	/**
	 * 卖家商品规格id（菜园跳转十荟团下单确认页时参数传递）
	 */
	@ApiField("sku_id")
	private String skuId;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getGoodsId() {
		return this.goodsId;
	}
	public void setGoodsId(String goodsId) {
		this.goodsId = goodsId;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutBizDate() {
		return this.outBizDate;
	}
	public void setOutBizDate(String outBizDate) {
		this.outBizDate = outBizDate;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getQuantity() {
		return this.quantity;
	}
	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getSellerId() {
		return this.sellerId;
	}
	public void setSellerId(String sellerId) {
		this.sellerId = sellerId;
	}

	public String getSkuId() {
		return this.skuId;
	}
	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
