package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 直付通结算信息修改接口
 *
 * @author auto create
 * @since 1.0, 2020-10-30 14:25:26
 */
public class AntMerchantExpandIndirectZftsettleinfoModifyModel extends AlipayObject {

	private static final long serialVersionUID = 7797217121353637538L;

	/**
	 * 结算支付宝账号，不传则不变更，传了则覆盖更新。本字段要求与商户名称name同名(个体工商户可放宽到法人名称)，且是实名认证支付宝账户
	 */
	@ApiField("alipay_logon_id")
	private String alipayLogonId;

	/**
	 * 营业执照授权函。其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。当商户名与结算卡户名不一致时必填
	 */
	@ApiField("auth_letter_image")
	private String authLetterImage;

	/**
	 * 结算卡，当前只允许至多一张。不传则不变更，传了则覆盖更新
	 */
	@ApiListField("biz_cards")
	@ApiField("settle_card_info")
	private List<SettleCardInfo> bizCards;

	/**
	 * 默认结算规则，不传则不变更，传了则覆盖更新。当调用收单接口，结算条款中设置默认结算规则时，交易资金将结算至此处设置的默认结算目标账户中。其详细描述及收单接口传参示例参考功能包文档
	 */
	@ApiField("default_settle_rule")
	private DefaultSettleRule defaultSettleRule;

	/**
	 * 待变更结算信息的smid
	 */
	@ApiField("smid")
	private String smid;

	public String getAlipayLogonId() {
		return this.alipayLogonId;
	}
	public void setAlipayLogonId(String alipayLogonId) {
		this.alipayLogonId = alipayLogonId;
	}

	public String getAuthLetterImage() {
		return this.authLetterImage;
	}
	public void setAuthLetterImage(String authLetterImage) {
		this.authLetterImage = authLetterImage;
	}

	public List<SettleCardInfo> getBizCards() {
		return this.bizCards;
	}
	public void setBizCards(List<SettleCardInfo> bizCards) {
		this.bizCards = bizCards;
	}

	public DefaultSettleRule getDefaultSettleRule() {
		return this.defaultSettleRule;
	}
	public void setDefaultSettleRule(DefaultSettleRule defaultSettleRule) {
		this.defaultSettleRule = defaultSettleRule;
	}

	public String getSmid() {
		return this.smid;
	}
	public void setSmid(String smid) {
		this.smid = smid;
	}

}
