package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 蚂蚁金服增值税发票ocr识别
 *
 * @author auto create
 * @since 1.0, 2020-11-30 11:14:13
 */
public class AntOcrVatinvoiceIdentifyModel extends AlipayObject {

	private static final long serialVersionUID = 3422154891954481777L;

	/**
	 * 目前只支持pdf、jpg两种file_type的识别能力，根据具体传入的发票的格式传入正确的值
	 */
	@ApiField("file_type")
	private String fileType;

	/**
	 * 对文件二进制内容做md5后的值，image_url和image_raw默认传一个，同时传入优先使用image_raw
	 */
	@ApiField("image_raw")
	private String imageRaw;

	/**
	 * 图片下载url，image_url和image_raw默认传一个，同时传入优先使用image_raw
	 */
	@ApiField("image_url")
	private String imageUrl;

	/**
	 * 标明调用来源
	 */
	@ApiField("source")
	private String source;

	/**
	 * 单次调用的唯一id，用于日常问题排查
	 */
	@ApiField("trace_id")
	private String traceId;

	public String getFileType() {
		return this.fileType;
	}
	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getImageRaw() {
		return this.imageRaw;
	}
	public void setImageRaw(String imageRaw) {
		this.imageRaw = imageRaw;
	}

	public String getImageUrl() {
		return this.imageUrl;
	}
	public void setImageUrl(String imageUrl) {
		this.imageUrl = imageUrl;
	}

	public String getSource() {
		return this.source;
	}
	public void setSource(String source) {
		this.source = source;
	}

	public String getTraceId() {
		return this.traceId;
	}
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

}
