package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * BPM审批结果回调
 *
 * @author auto create
 * @since 1.0, 2021-09-16 17:56:03
 */
public class AntProdpaasProcessSyncModel extends AlipayObject {

	private static final long serialVersionUID = 5524962714375988885L;

	/**
	 * 审批备注
	 */
	@ApiField("approve_remark")
	private String approveRemark;

	/**
	 * 审批时间
	 */
	@ApiField("approve_time")
	private Date approveTime;

	/**
	 * 审批人code，对应ERP系统的userCode
	 */
	@ApiField("approver_code")
	private String approverCode;

	/**
	 * 审批人名称
	 */
	@ApiField("approver_name")
	private String approverName;

	/**
	 * ERP系统唯一业务标识，创建时所提供的
	 */
	@ApiField("biz_id")
	private String bizId;

	/**
	 * 对应ERP系统业务类型
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 蚂蚁BPM对应的puid
	 */
	@ApiField("puid")
	private String puid;

	/**
	 * 审批驳回：-1
审批通过：2
	 */
	@ApiField("status")
	private String status;

	/**
	 * 审批状态名称
	 */
	@ApiField("status_name")
	private String statusName;

	public String getApproveRemark() {
		return this.approveRemark;
	}
	public void setApproveRemark(String approveRemark) {
		this.approveRemark = approveRemark;
	}

	public Date getApproveTime() {
		return this.approveTime;
	}
	public void setApproveTime(Date approveTime) {
		this.approveTime = approveTime;
	}

	public String getApproverCode() {
		return this.approverCode;
	}
	public void setApproverCode(String approverCode) {
		this.approverCode = approverCode;
	}

	public String getApproverName() {
		return this.approverName;
	}
	public void setApproverName(String approverName) {
		this.approverName = approverName;
	}

	public String getBizId() {
		return this.bizId;
	}
	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getPuid() {
		return this.puid;
	}
	public void setPuid(String puid) {
		this.puid = puid;
	}

	public String getStatus() {
		return this.status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatusName() {
		return this.statusName;
	}
	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

}
