package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 发票类型对应的发票可开票金额和税损信息
 *
 * @author auto create
 * @since 1.0, 2019-12-12 18:21:07
 */
public class ApMonthlyBillLossAmtOpenApiResponse extends AlipayObject {

	private static final long serialVersionUID = 8233945221642928637L;

	/**
	 * 月账单号
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 税损扣除后月账单可关联发票金额
	 */
	@ApiField("can_invoice_amt")
	private MultiCurrencyMoneyOpenApi canInvoiceAmt;

	/**
	 * 签约对象
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 月账单原始可关联发票金额
	 */
	@ApiField("orig_can_invoice_amt")
	private MultiCurrencyMoneyOpenApi origCanInvoiceAmt;

	/**
	 * 月账单原始应结算金额
	 */
	@ApiField("orig_real_bill_chk_amt")
	private MultiCurrencyMoneyOpenApi origRealBillChkAmt;

	/**
	 * 月账单原始未金额金额
	 */
	@ApiField("orig_un_settle_amt")
	private MultiCurrencyMoneyOpenApi origUnSettleAmt;

	/**
	 * 税损扣除后应结算金额
	 */
	@ApiField("real_bill_chk_amt")
	private MultiCurrencyMoneyOpenApi realBillChkAmt;

	/**
	 * 月账单税损金额
	 */
	@ApiField("tax_loss_amt")
	private MultiCurrencyMoneyOpenApi taxLossAmt;

	/**
	 * 发票税损比例
	 */
	@ApiField("tax_loss_rate")
	private Long taxLossRate;

	/**
	 * 税损扣除后未结算金额
	 */
	@ApiField("un_settle_amt")
	private MultiCurrencyMoneyOpenApi unSettleAmt;

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public MultiCurrencyMoneyOpenApi getCanInvoiceAmt() {
		return this.canInvoiceAmt;
	}
	public void setCanInvoiceAmt(MultiCurrencyMoneyOpenApi canInvoiceAmt) {
		this.canInvoiceAmt = canInvoiceAmt;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public MultiCurrencyMoneyOpenApi getOrigCanInvoiceAmt() {
		return this.origCanInvoiceAmt;
	}
	public void setOrigCanInvoiceAmt(MultiCurrencyMoneyOpenApi origCanInvoiceAmt) {
		this.origCanInvoiceAmt = origCanInvoiceAmt;
	}

	public MultiCurrencyMoneyOpenApi getOrigRealBillChkAmt() {
		return this.origRealBillChkAmt;
	}
	public void setOrigRealBillChkAmt(MultiCurrencyMoneyOpenApi origRealBillChkAmt) {
		this.origRealBillChkAmt = origRealBillChkAmt;
	}

	public MultiCurrencyMoneyOpenApi getOrigUnSettleAmt() {
		return this.origUnSettleAmt;
	}
	public void setOrigUnSettleAmt(MultiCurrencyMoneyOpenApi origUnSettleAmt) {
		this.origUnSettleAmt = origUnSettleAmt;
	}

	public MultiCurrencyMoneyOpenApi getRealBillChkAmt() {
		return this.realBillChkAmt;
	}
	public void setRealBillChkAmt(MultiCurrencyMoneyOpenApi realBillChkAmt) {
		this.realBillChkAmt = realBillChkAmt;
	}

	public MultiCurrencyMoneyOpenApi getTaxLossAmt() {
		return this.taxLossAmt;
	}
	public void setTaxLossAmt(MultiCurrencyMoneyOpenApi taxLossAmt) {
		this.taxLossAmt = taxLossAmt;
	}

	public Long getTaxLossRate() {
		return this.taxLossRate;
	}
	public void setTaxLossRate(Long taxLossRate) {
		this.taxLossRate = taxLossRate;
	}

	public MultiCurrencyMoneyOpenApi getUnSettleAmt() {
		return this.unSettleAmt;
	}
	public void setUnSettleAmt(MultiCurrencyMoneyOpenApi unSettleAmt) {
		this.unSettleAmt = unSettleAmt;
	}

}
