package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 应付月账单核销明细
 *
 * @author auto create
 * @since 1.0, 2019-12-11 09:37:00
 */
public class ApMonthlyBillPayDtlOpenApiResponse extends AlipayObject {

	private static final long serialVersionUID = 7157279517436437617L;

	/**
	 * 批次号：核销批次号，通常对应一个付款单或一次抵扣核销，通过该批次号可以找到合并在一起核销的账单
	 */
	@ApiField("batch_no")
	private String batchNo;

	/**
	 * 关联应付账单号（应付月账单号或应付日账单号）
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 结算对象（PID）
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 备注
	 */
	@ApiField("memo")
	private String memo;

	/**
	 * 该账单本次核销金额
	 */
	@ApiField("pay_amt")
	private MultiCurrencyMoneyOpenApi payAmt;

	/**
	 * 付款资金渠道{"01":"支付宝CAE代扣资金渠道","02":"支付宝即时到账资金渠道","03":"银行流水资金渠道","04":"支付宝统一下单并支付服务资金渠道","05":"支付宝B2C付款资金渠道","07":"支付宝到支付宝付款","08":"银行卡到银行卡付款","09":"支付宝到银行卡付款","99":"内部资金渠道","10":"支付宝流水资金渠道","11":"国际银行卡到银行卡付款"}
	 */
	@ApiField("pay_channel")
	private String payChannel;

	/**
	 * 付款日期
	 */
	@ApiField("pay_date")
	private Date payDate;

	/**
	 * 付款流水号
	 */
	@ApiField("pay_no")
	private String payNo;

	/**
	 * 付款原因
	 */
	@ApiField("pay_reason")
	private String payReason;

	/**
	 * 收款方账户名称，银行支付渠道时使用
	 */
	@ApiField("payee_account_name")
	private String payeeAccountName;

	/**
	 * 收款方机构名称，银行支付渠道时使用
	 */
	@ApiField("payee_inst_name")
	private String payeeInstName;

	/**
	 * 收款对象（UID），支付宝渠道时为UID，银行渠道时可能为空也可能和收款方结算对象一致
	 */
	@ApiField("payee_ip_role_id")
	private String payeeIpRoleId;

	/**
	 * 付款方扣款账号名称，银行支付渠道时使用
	 */
	@ApiField("payer_account_name")
	private String payerAccountName;

	/**
	 * 付款方扣款机构名称，银行支付渠道时使用
	 */
	@ApiField("payer_inst_name")
	private String payerInstName;

	/**
	 * 付款方扣款对象（UID），支付宝渠道时为UID
	 */
	@ApiField("payer_ip_role_id")
	private String payerIpRoleId;

	/**
	 * 处理状态{"01":"初始化","02":"审批中","03":"处理中","04":"驳回","05":"处理失败","06":"处理成功","07":"废弃","08":"人工介入","10":"校验中","11":"校验通过","12":"校验不通过","13":"异步处理中"}
	 */
	@ApiField("process_status")
	private String processStatus;

	/**
	 * 总核销金额
	 */
	@ApiField("rcpt_amt")
	private MultiCurrencyMoneyOpenApi rcptAmt;

	/**
	 * 付款单据号，账单所对应的付款单
	 */
	@ApiField("rcpt_no")
	private String rcptNo;

	/**
	 * 付款单据号，账单所对应的付款单审批工单号
	 */
	@ApiField("rcpt_workflow_no")
	private String rcptWorkflowNo;

	/**
	 * 付款状态{"00":"初始","01":"人工待处理","02":"审批中","03":"待支付","04":"支付中","05":"支付失败","06":"作废","07":"支付成功"}
	 */
	@ApiField("receipt_status")
	private String receiptStatus;

	/**
	 * 核销类型：表示该账单是通过抵扣方式核销还是付款方式核销{"01":"充值核销","02":"余额核销","03":"资金凭证核销","04":"业务凭证核销","05":"正负合并抵扣核销","06":"预付冲销应付","07":"收款单核销"}
	 */
	@ApiField("writeoff_flow_type")
	private String writeoffFlowType;

	public String getBatchNo() {
		return this.batchNo;
	}
	public void setBatchNo(String batchNo) {
		this.batchNo = batchNo;
	}

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getMemo() {
		return this.memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}

	public MultiCurrencyMoneyOpenApi getPayAmt() {
		return this.payAmt;
	}
	public void setPayAmt(MultiCurrencyMoneyOpenApi payAmt) {
		this.payAmt = payAmt;
	}

	public String getPayChannel() {
		return this.payChannel;
	}
	public void setPayChannel(String payChannel) {
		this.payChannel = payChannel;
	}

	public Date getPayDate() {
		return this.payDate;
	}
	public void setPayDate(Date payDate) {
		this.payDate = payDate;
	}

	public String getPayNo() {
		return this.payNo;
	}
	public void setPayNo(String payNo) {
		this.payNo = payNo;
	}

	public String getPayReason() {
		return this.payReason;
	}
	public void setPayReason(String payReason) {
		this.payReason = payReason;
	}

	public String getPayeeAccountName() {
		return this.payeeAccountName;
	}
	public void setPayeeAccountName(String payeeAccountName) {
		this.payeeAccountName = payeeAccountName;
	}

	public String getPayeeInstName() {
		return this.payeeInstName;
	}
	public void setPayeeInstName(String payeeInstName) {
		this.payeeInstName = payeeInstName;
	}

	public String getPayeeIpRoleId() {
		return this.payeeIpRoleId;
	}
	public void setPayeeIpRoleId(String payeeIpRoleId) {
		this.payeeIpRoleId = payeeIpRoleId;
	}

	public String getPayerAccountName() {
		return this.payerAccountName;
	}
	public void setPayerAccountName(String payerAccountName) {
		this.payerAccountName = payerAccountName;
	}

	public String getPayerInstName() {
		return this.payerInstName;
	}
	public void setPayerInstName(String payerInstName) {
		this.payerInstName = payerInstName;
	}

	public String getPayerIpRoleId() {
		return this.payerIpRoleId;
	}
	public void setPayerIpRoleId(String payerIpRoleId) {
		this.payerIpRoleId = payerIpRoleId;
	}

	public String getProcessStatus() {
		return this.processStatus;
	}
	public void setProcessStatus(String processStatus) {
		this.processStatus = processStatus;
	}

	public MultiCurrencyMoneyOpenApi getRcptAmt() {
		return this.rcptAmt;
	}
	public void setRcptAmt(MultiCurrencyMoneyOpenApi rcptAmt) {
		this.rcptAmt = rcptAmt;
	}

	public String getRcptNo() {
		return this.rcptNo;
	}
	public void setRcptNo(String rcptNo) {
		this.rcptNo = rcptNo;
	}

	public String getRcptWorkflowNo() {
		return this.rcptWorkflowNo;
	}
	public void setRcptWorkflowNo(String rcptWorkflowNo) {
		this.rcptWorkflowNo = rcptWorkflowNo;
	}

	public String getReceiptStatus() {
		return this.receiptStatus;
	}
	public void setReceiptStatus(String receiptStatus) {
		this.receiptStatus = receiptStatus;
	}

	public String getWriteoffFlowType() {
		return this.writeoffFlowType;
	}
	public void setWriteoffFlowType(String writeoffFlowType) {
		this.writeoffFlowType = writeoffFlowType;
	}

}
