package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 应用授权令牌
 *
 * @author auto create
 * @since 1.0, 2020-10-14 16:42:39
 */
public class AppAuthToken extends AlipayObject {

	private static final long serialVersionUID = 1279195842783749849L;

	/**
	 * 老插件订购场景中，插件所属的应用id
	 */
	@ApiField("agent_app_id")
	private String agentAppId;

	/**
	 * 授权的接口包信息
	 */
	@ApiListField("auth_api_packages")
	@ApiField("string")
	private List<String> authApiPackages;

	/**
	 * 执行授权的商户应用在开放平台的应用id
	 */
	@ApiField("auth_app_id")
	private String authAppId;

	/**
	 * 授权结束时间
	 */
	@ApiField("auth_end")
	private String authEnd;

	/**
	 * 授权场景
	 */
	@ApiField("auth_scene")
	private String authScene;

	/**
	 * 授权开始时间
	 */
	@ApiField("auth_start")
	private Date authStart;

	/**
	 * 授权token
	 */
	@ApiField("auth_token")
	private String authToken;

	/**
	 * isv的应用id
	 */
	@ApiField("isv_app_id")
	private String isvAppId;

	public String getAgentAppId() {
		return this.agentAppId;
	}
	public void setAgentAppId(String agentAppId) {
		this.agentAppId = agentAppId;
	}

	public List<String> getAuthApiPackages() {
		return this.authApiPackages;
	}
	public void setAuthApiPackages(List<String> authApiPackages) {
		this.authApiPackages = authApiPackages;
	}

	public String getAuthAppId() {
		return this.authAppId;
	}
	public void setAuthAppId(String authAppId) {
		this.authAppId = authAppId;
	}

	public String getAuthEnd() {
		return this.authEnd;
	}
	public void setAuthEnd(String authEnd) {
		this.authEnd = authEnd;
	}

	public String getAuthScene() {
		return this.authScene;
	}
	public void setAuthScene(String authScene) {
		this.authScene = authScene;
	}

	public Date getAuthStart() {
		return this.authStart;
	}
	public void setAuthStart(Date authStart) {
		this.authStart = authStart;
	}

	public String getAuthToken() {
		return this.authToken;
	}
	public void setAuthToken(String authToken) {
		this.authToken = authToken;
	}

	public String getIsvAppId() {
		return this.isvAppId;
	}
	public void setIsvAppId(String isvAppId) {
		this.isvAppId = isvAppId;
	}

}
