package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 资金存管服务资产信息
 *
 * @author auto create
 * @since 1.0, 2021-12-02 17:26:35
 */
public class AssetInfoDTO extends AlipayObject {

	private static final long serialVersionUID = 6717957489147971152L;

	/**
	 * 账号
	 */
	@ApiField("account_no")
	private String accountNo;

	/**
	 * 分账资产类型，监管户、托管资产 、 余额户 、外部资产
	 */
	@ApiField("asset_type")
	private String assetType;

	/**
	 * 用户id或二级商户smid，2088开头16位数字。
	 */
	@ApiField("user_id")
	private String userId;

	/**
	 * 提现到卡信息，提现到卡必填
	 */
	@ApiField("withdraw_bank_card_info_dto")
	private WithdrawBankCardInfoDTO withdrawBankCardInfoDto;

	public String getAccountNo() {
		return this.accountNo;
	}
	public void setAccountNo(String accountNo) {
		this.accountNo = accountNo;
	}

	public String getAssetType() {
		return this.assetType;
	}
	public void setAssetType(String assetType) {
		this.assetType = assetType;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public WithdrawBankCardInfoDTO getWithdrawBankCardInfoDto() {
		return this.withdrawBankCardInfoDto;
	}
	public void setWithdrawBankCardInfoDto(WithdrawBankCardInfoDTO withdrawBankCardInfoDto) {
		this.withdrawBankCardInfoDto = withdrawBankCardInfoDto;
	}

}
